import { Decorator } from "../Decorator/Decorator";
import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import MainScene from "../Scene/MainScene";
import Loading from "../../loading/Loading";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import UsePropsPanel from "./UsePropsPanel";
import ToastPanel from "../MComponents/MToastPanel";
import { MConfigs } from "../Global/MConfigs";
import Net from "../Global/Net";

@Decorator.ClassName("GameOverPanel")
@Decorator.OnUpdate
export default class GameOverPanel extends Panel implements Decorator.IDefaultCallback {
    public btnClose: MButton;
    public labelScore: eui.Label;
    public labelTopScore: eui.Label;
    public btnRestart: MButton;
    public btnUseProps: MButton;
    private context: MainScene;
    private timestamp: number = null;

    haveprizecont: eui.Group;
    prizesp1: eui.Group;
    prizetxt1: eui.Label;
    prizesp2: eui.Group;
    prizetxt2: eui.Label;
    prizesp3: eui.Group;
    prizetxt3: eui.Label;

    btngro: eui.Group;
    overdata;

    // hnprize = false;
    // p1data = {
    //     count: 0,
    //     posx: 0,
    // };
    // p2data = {
    //     count: 0,
    //     posx: 0,
    // };
    // p3data = {
    //     count: 0,
    //     posx: 0,
    // };
    constructor() {
        super();
        this.timestamp = egret.getTimer();
    }

    init(context: MainScene, overdata) {
        this.context = context;
        this.overdata = overdata;
    }

    onUpdate() {
        if (egret.getTimer() - this.timestamp > MConfigs.GameOverPanelStayTime) {
            this.onClose();
        }
    }

    onNetError() {
        this.onClose();
    }

    onSkinComplete() {

        //新奖品返回
        let hnprize = false;
        let p1data = {
            count: 0,
            posx: 0,
        },
            p2data = {
                count: 0,
                posx: 0,
            },
            p3data = {
                count: 0,
                posx: 0,
            };
        if (this.overdata && this.overdata.data && this.overdata.data.gameAward) {
            let gameAward = this.overdata.data.gameAward;
            let prizenum = 0;
            if (gameAward) {
                let awardsps = gameAward.sps;
                if (awardsps && awardsps.length) {
                    for (let onesp of awardsps) {
                        let { award, sp } = onesp;
                        if (award > 0) {
                            hnprize = true;
                            if (sp == "sp_food_1") {//饲料
                                p3data = {
                                    count: award,
                                    posx: 0,
                                }
                                prizenum++;
                            } else if (sp == "sp_food_2") {//水壶
                                p2data = {
                                    count: award,
                                    posx: 0,
                                }
                                prizenum++;
                            } else if (sp == "sp_prop_1") {//加速卡
                                p1data = {
                                    count: award,
                                    posx: 0,
                                }
                                prizenum++;
                            }
                        }
                    }
                }
            }
            if (prizenum == 3) {
                p1data.posx = 50;
                p2data.posx = 217;
                p3data.posx = 383;
            } else if (prizenum == 2) {
                let havepos1 = false;
                if (p1data.count > 0) {
                    p1data.posx = 50;
                    havepos1 = true;
                }
                if (p2data.count > 0) {
                    p2data.posx = havepos1 ? 383 : 50;
                    havepos1 = true;
                }
                if (p3data.count > 0) {
                    p3data.posx = havepos1 ? 383 : 50;
                    havepos1 = true;
                }
            } else if (prizenum == 1) {
                if (p1data.count > 0) {
                    p1data.posx = 217;
                }
                if (p2data.count > 0) {
                    p2data.posx = 217;
                }
                if (p3data.count > 0) {
                    p3data.posx = 217;
                }
            }
        }

        this.haveprizecont.visible = hnprize;
        this.prizesp1.visible = p1data.count>0;
        this.prizesp2.visible = p2data.count>0;
        this.prizesp3.visible = p3data.count>0;

        this.btngro.y = hnprize?620:425;

        this.prizetxt1.text = "x"+p1data.count;
        this.prizetxt2.text = "x"+p2data.count;
        this.prizetxt3.text = "x"+p3data.count;
        this.prizesp1.x = p1data.posx;
        this.prizesp2.x = p2data.posx;
        this.prizesp3.x = p3data.posx;





        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.onClose();
        });

        this.labelScore.text = this.context.score.toString();
        this.labelTopScore.text = (this.context.maxScore || this.context.score).toString()

        this.btnRestart.onTap(this, () => {
            this.onClose();
        });

        this.btnUseProps.onTap(this, () => {
            PanelCtrl.instance.show<UsePropsPanel>(UsePropsPanel).init(
                this,
                this.context,
                (id) => {
                    if (typeof id == "string") { //使用的是加分卡
                        this.context.finalSubmit(id, () => {
                            ToastPanel.show("加分成功", true, () => {
                                PanelCtrl.instance.closeAll();
                                SceneCtrl.instance.change(StartScene);
                            });
                        });
                    } else { //使用的是复活卡
                        this.hidePanel();
                    }
                }
            );
        });
    }

    private onClose() {
        PanelCtrl.instance.closeAll();
        SceneCtrl.instance.change(StartScene);
        // this.context.finalSubmit(undefined, () => {
        //     SceneCtrl.instance.change(StartScene);
        // });
    }
}