import StartSceneBase from "../../libs/new_wx/components/StartSceneBase";
import { GravityParticleSystem } from "../../libs/Particle/GravityParticleSystem";
// tslint:disable
export default class StartScene extends StartSceneBase {

    async start(data?) {
        super.start();

        await Promise.all([
            RES.getResAsync("ballParticle_png"),
            RES.getResAsync("ballParticle_json"),
            RES.getResAsync("firePot_png")
        ]);

        const bg = new egret.Bitmap();
        bg.texture = await RES.getRes("firePot_png");
        this.addChild(bg);
        bg.x = this.stage.stageWidth / 2 - bg.width / 2 - 50;
        bg.y = this.stage.stageHeight / 2 - bg.height / 2 - 210;
        bg.scaleX = bg.scaleY = 1.8;

        /*** 本示例关键代码段开始 ***/

        var system = new GravityParticleSystem(
            await RES.getRes("ballParticle_png"),
            await RES.getRes("ballParticle_json")
        );
        this.addChild(system);
        system.start();
        system.y = this.stage.stageHeight / 2;
        system.x = this.stage.stageWidth / 2;
        system.emitterX = 0;
        system.emitterY = 0;
        system.scaleX = system.scaleY = 1.5;

        bg.y += 500;
        system.y += 500;
        /*** 本示例关键代码段结束 ***/
    }

}