import { IModuleData } from "../interface/IModuleData";
import { IDestroy } from "../interface/IDestroy";

/**
 *Created by cuiliqiang on 2018/3/1
 * 组件基类
 */
export abstract class ABModule implements IDestroy {
    /**
     * 模块数据
     */
    private _data: IModuleData;

    /**
     * 视图层
     */
    private _view: any;

    constructor(data: IModuleData) {
        this._data = data;

        let viewClass: any;
        if (typeof this.data.viewClass === 'string') {
            viewClass = eval(this.data.viewClass);
        } else {
            viewClass = this.data.viewClass;
        }
        this._view = new viewClass();
    }

    /**
     * 初始化模型
     */
    protected abstract initModel(): void

    /**
     * 初始化UI
     */
    protected abstract initUI(): void

    /**
     * 显示
     */
    protected abstract show(): void

    /**
     * 隐藏
     */
    protected abstract hide(): void

    /**
     * 添加事件
     */
    protected abstract addEvent(): void

    /**
     * 移除事件
     */
    protected abstract removeEvent(): void

    /**
     * 更新页面
     * @param args
     */
    public abstract updateData(...args): void

    /**
     * 播放进场动画
     * @param callback 回调函数
     */
    public abstract playShowAnimation(callback?: Function): void

    /**
     * 播放退场动画
     * @param callback 回调函数
     */
    public abstract playHideAnimation(callback?: Function): void

    /**
     * 销毁
     */
    public abstract dispose(): void

    /**
     * 模块数据
     * @returns {IModuleData}
     */
    public get data(): IModuleData {
        return this._data;
    }

    /**
     * 视图
     * @returns {any}
     */
    protected get view(): any {
        return this._view;
    }
}