import wait from "../../libs/new_tc/wait";
import plugDoJoin from "../../libs/new_tw/ctrls/doPluginJoin";
import plugIsWinning from "../../libs/new_tw/datas/plugIsWinning";
import Loading from "../../libs/new_wx/components/Loading";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { award } from "./collisionConfig";
import { stopCreateItems } from "./createItems";
import LabelType from "./LabelType";
import { addItem, clearLevel, isAllLevelPass, isLevelPass, nextLevel } from "./level";
import { playBoom, playBoomAlert, playSuccess, playToast, playToastSuccess } from "./playMovieClip";
import StartScene from "./StartScene";
import vibrate from "./vibrate";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";

const removeAward = (_this: StartScene) => {
    const bodies = Matter.Composite.allBodies(_this._engine.world);
    const isAward = (i: Matter.Body) => { return i.collisionFilter.group == award };
    bodies.forEach(i => {
        if (isAward(i)) _this._egretRender.remove(i);
    });
}

const check = (_this: StartScene) => {
    const center = 109 - 40;
    const paddingX = 30;
    const ypos = 1386 - 110;
    const h = 100;

    const center2 = 643 + 8;
    const paddingX2 = 40 + 5;
    const ypos2 = 1386 - 20 - 5 - 110;
    const h2 = 50;

    // _this._egretRender._root.graphics.beginFill(0xff0000, 1);
    // _this._egretRender._root.graphics.drawRect(center - paddingX, ypos, paddingX * 2, h);
    // _this._egretRender._root.graphics.endFill();
    // _this._egretRender._root.graphics.beginFill(0xff0000, 1);
    // _this._egretRender._root.graphics.drawRect(center2 - paddingX2, ypos2, paddingX2 * 2, h2);
    // _this._egretRender._root.graphics.endFill();

    const bodies = Matter.Composite.allBodies(_this._engine.world);
    const isAward = (i: Matter.Body) => { return i.collisionFilter.group == award }
    bodies.forEach(async (i) => {
        if (!isAward(i)) return;
        if (i['timer']) {
            const t0 = Date.now() - i['timer'];
            if (t0 > 3000)//3s之内不可再用
            {
                delete i['timer'];
                console.log('重新可用', Date.now() / 1000)
            }
        }
        const { x, y } = i.position;
        if (y > 1624 - 100) {
            _this._egretRender.remove(i);
            return;
        }
        const xResult = x > (center - paddingX) && x < (center + paddingX);
        const yResult = y > ypos && y < (ypos + h);
        const xResult2 = x > (center2 - paddingX2) && x < (center2 + paddingX2);
        const yResult2 = y > ypos2 && y < (ypos2 + h2);
        const fallingIn = xResult && yResult || xResult2 && yResult2;
        if (fallingIn && i.velocity.y > 0 && !i['timer']) {
            i['timer'] = Date.now();
            // console.log(i.label);
            playToast(_this, i.label, xResult && yResult);
            if (xResult && yResult) {
                //leftbasket rightbasket
                egret.Tween.removeTweens(_this['leftbasket']);
                egret.Tween.removeTweens(_this['leftbasket1']);
                egret.Tween.get(_this['leftbasket']).to({ scaleX: 1.2 }, 100).to({ scaleX: 1 }, 100);
                egret.Tween.get(_this['leftbasket1']).to({ scaleX: 1.2 }, 100).to({ scaleX: 1 }, 100);
            } else {
                egret.Tween.removeTweens(_this['rightbasket']);
                egret.Tween.removeTweens(_this['rightbasket1']);
                egret.Tween.get(_this['rightbasket']).to({ scaleX: 1.2 }, 100).to({ scaleX: 1 }, 100);
                egret.Tween.get(_this['rightbasket1']).to({ scaleX: 1.2 }, 100).to({ scaleX: 1 }, 100);
            }
            if (i.label == LabelType.Boom) {
                _this._egretRender.remove(i);
                if (xResult && yResult) {
                    //左边ok
                } else {
                    //右边clear
                    clearLevel();
                    vibrate(_this, 2);
                    playBoomAlert(_this)
                    playBoom(_this['group']);
                    removeAward(_this);
                    stopCreateItems();
                    await wait(700);
                    Loading.instace.show();
                    plugDoJoin(() => {
                        Loading.instace.hide();
                        if (plugIsWinning())
                            PanelCtrl.instance.show(ModuleTypes.BoomPrizePanel);
                        else
                            PanelCtrl.instance.show(ModuleTypes.BoomNoPrizePanel);
                    }, window['pluginID']);
                }
            }
            else {
                if (xResult2 && yResult2) {
                    playSuccess(_this['group']);
                    await addItem(i.label);

                    if (isLevelPass()) {
                        if (isAllLevelPass()) {
                            stopCreateItems();
                            removeAward(_this);

                            Loading.instace.show();
                            plugDoJoin(() => {
                                Loading.instace.hide();
                                if (plugIsWinning()) {
                                    if (DataManager.ins.getPlugOrderStatusData.lottery.type == LotteryType.OBJECT)
                                        PanelCtrl.instance.show(ModuleTypes.CashBigPrize);
                                    else
                                        PanelCtrl.instance.show(ModuleTypes.CashPrizePanel);
                                }
                                else
                                    PanelCtrl.instance.show(ModuleTypes.CashNoPrizePanel);
                            }, window['pluginBigPrizeID']);

                        } else {
                            playToastSuccess(_this)
                            nextLevel();
                        }
                    }
                }
                // console.log('不是boom', Date.now() / 1000);
                _this._egretRender.remove(i);
            }

        }
    })


}

export default check