import showPlugLog from "../../libs/new_tw/ctrls/showPlugLog";
import Panel from "../../libs/new_wx/components/Panel";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class BoomPrizePanel extends Panel {
    start(data) {
        const lottery = DataManager.ins.getPlugOrderStatusData.lottery;
        this.data = lottery;

        this.img.width = this.picBigWidth;
        this.img.height = this.picBigWidth / this.bigPicRatio;

        showPlugLog(lottery);
    }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery = DataManager.ins.getPlugOrderStatusData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    get skinKey() { return 'BoomPrize' }

    img: eui.Image;
    useBtn: eui.Button;

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}