import { NetManager } from "../../tw/manager/NetManager";
import { DataManager } from "../../tw/manager/DataManager";

/**
 * 插件抽奖订单结果
 * @param net 
 */
const getPlugOrderStatus = (callback: Function) => {
    NetManager.ins.getPlugOrderStatus(callback, DataManager.ins.doJoinPlugDrawData.orderId, () => {
        return DataManager.ins.getPlugOrderStatusData.result == 0;
    });
}

/**
 * 插件抽奖
 * @param callback
 * @param plugId 
 */
const plugDoJoin = (callback: Function, plugId: number) => {
    NetManager.ins.doJoinPlugDraw((success: boolean) => {
        if (success) {
            getPlugOrderStatus(callback);
        } else {
            callback(success);
        }
    }, plugId);
}

export default plugDoJoin
