import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import Alert from "./alert/Alert";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import OptionsPanel from "./optionsPanel/OptionsPanel";
import RulePanel from "./rulePanel/RulePanel";
import StartScene from "./startScene/StartScene";
import { ModuleTypes } from "./types/sceneTypes";
import PrizePanel from "./prizePanel/PrizePanel";

class Main extends MainBase {
    protected registerModules() {
        PanelCtrl.instance.registerPanelClass(ModuleTypes.ALERT_PANEL, Alert);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.OPTIONS_PANEL, OptionsPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.PRIZE_PANEL, PrizePanel);

        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);
    }

    protected getData() {
        super.getData();
        NetManager.ins.getInfo();
    }

    protected async createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}

window['Main'] = Main;

setTimeout(() => {


    egret.runEgret({
        renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context: any) {
            var backingStore = context.backingStorePixelRatio ||
                context.webkitBackingStorePixelRatio ||
                context.mozBackingStorePixelRatio ||
                context.msBackingStorePixelRatio ||
                context.oBackingStorePixelRatio ||
                context.backingStorePixelRatio || 1;
            return (window.devicePixelRatio || 1) / backingStore;
        }
    });

}, 1000);