import Panel from "../views/Panel";
import Tween = egret.Tween;
import {loadSvga} from "../comm/loadSvga";
import {getSvga} from "../utils";

export default class Guide extends Panel {

    public group: eui.Group;
    public bg: eui.Image;
    public guideBack: eui.Group;
    public guide1: eui.Group;
    public guide1_tip: eui.Image;
    public guide1_btn: eui.Button;
    public guide2: eui.Group;
    public guide2_tip: eui.Image;
    public guide2_btn: eui.Button;
    public guide3: eui.Group;
    public guide3_tip: eui.Image;
    public guide3_btn: eui.Button;
    public guideFrog: eui.Group;
    public handGroup: eui.Group;
    public point: eui.Image;
    public hand: eui.Image;

    public cancel: eui.Image;


    public get skinKey() {
        return 'Guide'
    }

    public get groupName() {
        return 'guide'
    }

    constructor(data?) {
        super(data);

    }

    onShowAnim() {
        return Tween.get(this);
    }

    onHide(): egret.Tween {
        return Tween.get(this);
    }

    protected async start() {
        super.start();
        this.height = 750 / window.innerWidth * window.innerHeight;

        const mv = await loadSvga(getSvga('guide_panda'));
        this.guideFrog.addChild(mv);
        mv.x = 80;
        mv.y = 800;

        this.showGuide(this.guide1);
        this.showHand(460);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts()
            .concat([
                [this.guide1_btn, this.onTap, this],
                [this.guide2_btn, this.onTap, this],
                [this.guide3_btn, this.onTap, this],
                [this.cancel, this.onTap, this],
            ]);
    }

    private onTap(e) {
        switch (e.target) {
            case this.guide1_btn:
                this.guide1.visible = false;
                this.showGuide(this.guide2);
                this.showHand(285);
                break;

            case this.guide2_btn:
                this.guide2.visible = false;
                this.showGuide(this.guide3);
                this.showHand(120);
                break;

            case this.cancel:
            case this.guide3_btn:
                const popup = this.data.call();
                popup ? 0 : (this.hidePanel(), this.data.f());
                break;
        }
    }

    public showGuide(node) {
        Tween.get(node)
            .set({alpha: 0, visible: true})
            .to({alpha: 1}, 500);
    }

    public showHand(x) {
        Tween.get(this.handGroup)
            .set({visible: true, alpha: 0, x: x})
            .wait(500)
            .to({alpha: 1}, 400)
            .call(() => {
                this.handEffect();
            });
    }

    public handEffect() {
        const _x = this.hand.x;
        const _y = this.hand.y;

        const duration = 750;

        Tween.get(this.hand)
            .to({x: _x - 30, y: _y - 30}, duration)
            .to({x: _x, y: _y}, duration)
            .to({x: _x - 30, y: _y - 30}, duration)
            .to({x: _x, y: _y}, duration)
            .to({x: _x - 30, y: _y - 30}, duration)
            .to({x: _x, y: _y}, duration);

        Tween.get(this.point)
            .to({scaleX: 1, scaleY: 1}, duration)
            .to({scaleX: 0.5, scaleY: 0.5}, duration)
            .to({scaleX: 1, scaleY: 1}, duration)
            .to({scaleX: 0.5, scaleY: 0.5}, duration)
            .to({scaleX: 1, scaleY: 1}, duration)
            .to({scaleX: 0.5, scaleY: 0.5}, duration)
            .call(() => {
                Tween.get(this.handGroup)
                    .set({visible: true, alpha: 0});
            });
    }

    public initEvents() {
        super.initEvents();
    }

    public removeEvents() {
        super.removeEvents();
    }

}
