"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var MedalPanel = (function (_super) {
    __extends(MedalPanel, _super);
    function MedalPanel(data) {
        return _super.call(this, data) || this;
    }
    MedalPanel.prototype.onShowAnim = function () {
        // 缩放：0s(0%,0%)-0.23s（120%，120%）-0.33s(100%,100%);
        // 文案和按钮 透明度：0.33s(0%)-0.67s(100%);
        this.anchorOffsetX = 750 / 2;
        this.anchorOffsetY = 900 / 2;
        this.x = 750 / 2;
        this.y = 750 / window.innerWidth * window.innerHeight * 0.15 + 900 / 2;
        egret.Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1.2, scaleY: 1.2 }, 230)
            .to({ scaleX: 1, scaleY: 1 }, 100);
    };
    MedalPanel.prototype.onShowAnimCall = function () {
        egret.Tween.get(this.btn)
            .set({ alpha: 0 })
            .wait(330)
            .to({ alpha: 1 }, 340);
        egret.Tween.get(this.title)
            .set({ alpha: 0 })
            .wait(330)
            .to({ alpha: 1 }, 340);
    };
    MedalPanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.btn, this.onTap, this],
        ]);
    };
    MedalPanel.prototype.onTap = function () {
        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.ROOM_SCENE, { auto: true });
    };
    MedalPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    MedalPanel.prototype.initUI = function () {
        egret.Tween.get(this.light, { loop: true }).to({ rotation: 360 }, 6000);
        /// TODO 设置 medal 和 mask 的 source
        this.medal.source = "medal_" + this.data + "_png";
        this.mask.source = "medal_" + this.data + "_png";
        this.swap_light.mask = this.mask;
        // 获得勋章的扫光动效
        // 0.67s-1.67s,间隔时间：1s;
        egret.Tween.get(this.swap_light, { loop: true })
            .set({ x: 198 })
            .wait(670)
            .to({ x: 444 }, 1000)
            .wait(330);
    };
    Object.defineProperty(MedalPanel.prototype, "skinKey", {
        get: function () {
            return 'MedalPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MedalPanel.prototype, "groupName", {
        get: function () {
            return 'medal_panel';
        },
        enumerable: true,
        configurable: true
    });
    return MedalPanel;
}(Panel_1.default));
exports.default = MedalPanel;
__reflect(MedalPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/MedalPanel\".MedalPanel");
//# sourceMappingURL=MedalPanel.js.map