import { GamePlayModel } from "../../libs/tw/model/game/GamePlayModel";
import Scene from "../views/Scene";
import BoxListCtrl from "./BoxListCtrl";
import Monkey from "./Monkey";
import Net from "./Net";
import Guide from "./Guide";
import GuideCtrl from "./GuideCtrl";

const { TouchEvent } = egret;
export default class StartScene extends Scene {
    private _net: Net;
    private _monkey: Monkey;
    private _shape: egret.Shape;
    private _boxList: BoxListCtrl;
    private _guideView: Guide;
    private _guideCtrl: GuideCtrl;
    async start(data?) {
        const t1 = Date.now() - __t0__;
        console.log(`startScene添加到stage:${t1 / 1000}s`)

        const picData: any = await this.getBg();
        const pic = new egret.Bitmap(picData);
        egret.Tween.get(pic).set({ alpha: 0 }).to({ alpha: 1 }, 500);
        this.getLayer(LayerTypes.bg).addChild(pic);
        const t2 = Date.now() - __t0__;
        console.log(`首屏(背景显示)时间:${t2 / 1000}s`);

        this._boxList = new BoxListCtrl(this.getLayer(LayerTypes.box));
        await this._boxList.createFirstBox();

        this._boxList.resume();
        const t3 = Date.now() - __t0__;
        console.log(`关键利益点时间:${t3 / 1000}s`);

        const monkey = new Monkey();
        this.getLayer(LayerTypes.monkey).addChild(monkey);
        monkey.addEventListener('pointUpdate', this.onPointUpdate, this)
        this._monkey = monkey;

        this._guideView = new Guide(this.getLayer(LayerTypes.guide));
        this._guideCtrl = new GuideCtrl(this);

        const net = new Net();
        this.getLayer(LayerTypes.net).addChild(net);
        this._net = net;


        if (__debug__) {
            this._shape = new egret.Shape();
            this.addChild(this._shape);
        }

        const model = new GamePlayModel();
        model.update();

        // box.touchEnabled = true;
        // box.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
        //     NetManager.ins.getInfo(() => {
        //         model.doStart(() => {
        //             model.submit(() => { }, box.boxData.award)
        //         }, false);
        //     });

        //     PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

        // }, this);
    }

    addTouchEvent() {
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    removeTouchEvent() {
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    onTouch() {
        this._net.doAction();
    }

    onPointUpdate(e: egret.Event) {
        const point = e.data as egret.Point;
        if (__debug__) {
            this._shape.graphics.clear();
            this._shape.graphics.beginFill(0xff0000);
            const size = __monkeyHandSize__;
            const x = point.x + this._monkey.x;
            const y = point.y + this._monkey.y;
            this._shape.graphics.drawRect(x - size / 2, y - size / 2, size, size);
            this._shape.graphics.endFill();
        }
    }
    async getBg() {
        let url = __bgUrl__
        return new Promise((resolve) => {
            RES.getResByUrl(url, (picData) => {
                resolve(picData)
            }, this, RES.ResourceItem.TYPE_IMAGE);
        });
    }

    protected get layerKeys() {
        return [
            LayerTypes.bg,
            LayerTypes.kids,
            LayerTypes.guide,
            LayerTypes.net,
            LayerTypes.box,
            LayerTypes.monkey,

        ]
    }
    protected get skinKey() { return 'Start' }
    get guideView() { return this._guideView }
    get monkey() { return this._monkey }
    get boxList() { return this._boxList }
    get net() { return this._net }
}

enum LayerTypes {
    bg, kids, box, net, monkey, guide
}