import StartScene from "./StartScene";
import Monkey from "./Monkey";

export default class GuideCtrl {
    private _main: StartScene;
    private _tag: boolean;
    constructor(view: StartScene) {
        this._main = view;
        this.init();
        if (this._tag) {
            this._main.guideView.destroy();
        } else {
            this.start();
        }
    }

    start(): any {
        this._main.monkey.once('onStartShaking', this.onMonkeyStartShaking, this);
        this._main.boxList.boxs[0].once('onPassMiddle', this.onPassMiddle, this);
    }

    onPassMiddle() {
        this._main.boxList.pause();
        this._main.once(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    onTouch() {
        // this._main.boxList.resume();
        this.setTag();
        this._main.guideView.destroy();
        this._main.onTouch();
        this._main.addTouchEvent();
    }

    onMonkeyStartShaking() {
        this._main.monkey.stop(Monkey.RANGE / 3)
    }

    private init() {
        this._tag = localStorage.getItem('guide') === '1';
    }

    setTag() {
        localStorage.setItem('guide', '1');
    }
}