'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api';
import { MODAL_NAME, MODAL_TYPE, JUMP_URL, ERROR_MESSSAGE } from "../../constant";
import { Toast, Loading, getModalHoc } from 'spark-design';
import './pagemainscene.less';
import { ICBCUtil } from '../../icbc_core'
import ruleMoadl from '../../components/comrulepanel/comrulepanel.jsx';
import { mHistory } from '../../BaseRouter.jsx';
const RuleModal = getModalHoc(ruleMoadl);

class Pagemainscene extends Component {
  constructor(props) {
    super(props);
    this.state = {
      modalType: "",
      prizeImg: "",
      // isDo: true,
      rule: ""
    };
  }
  /**
   * 弹窗控制器
   * @param {*} key 
   */
  modalControl(key) {
    console.log('打开弹窗--====', key, MODAL_TYPE[key]);
    this.setState({
      modalType: MODAL_TYPE[key]
    })
  }

  async setRuleData() {
    let { success, data, message, code } = await API.getRule();
    console.log('data---》》》》--', data);
    if (success) {
      this.setState({
        rule: data
      })
      this.modalControl(MODAL_NAME.P_RULE)
    } else {
      Toast(ERROR_MESSSAGE(code), 2000)
    }
  }

  async scenceJump() {
    console.log('场景跳转');
    mHistory.push({ pathname: '/a' });
  }
  /**
   * 跳转链接
   * @param {*} url 
   */
  jumpUrl(url) {
    console.log('url---------', url);
    this.state.isDo = true;
    console.log("isdo-----", this.state.isDo);
    setTimeout(() => {
      this.setState({
        isDo: true
      })
    }, 2000)
    if (this.state.isDo) {
      this.setState({
        isDo: false
      })
      if (url) {
        window.location.href = url;
      } else {
        Toast("请检查网络", 2000);
      }
    }
  }

  render() {
    let { modalType, prizeImg, rule } = this.state;
    return (
      <div className="mainscene point1">
        <img className="bg12 " src={resList['0086550d-2ac4-4217-be82-bab2fb4587fe'].url} />
        <div className="mainpage ">
          <img className="mainbg " src={resList['264a6134-1735-43c6-87ae-4143bf11ffde'].url} />
        </div>
        {/* <img className="backHomeBtn " src={resList['66eb7ce1-0581-438a-9798-d140f86623b3'].url} onClick={() => { ICBCUtil.returnBack() }} /> */}
        <div className='main-ui'>
          <img className="bankLogo" src={resList['66e62244-e960-45ce-9ae6-09a3efab360d'].url} />
          <img className="awardbtn " onClick={() => { this.jumpUrl(JUMP_URL.AWARD_URL); }} src={resList['03f842be-59cf-42e9-b845-71aec8da2ef7'].url} />
          <img className="rulebtn " onClick={() => { this.setRuleData() }} src={resList['f38cd0ee-a25a-49d7-b526-105c4129edbe'].url} />
          <img className="startbtn point2" onClick={() => { this.scenceJump() }} src={resList['fd891b60-f234-44f2-a6a8-0e759f5e4a77'].url} />
        </div>

        {modalType == MODAL_TYPE[MODAL_NAME.P_RULE] && <RuleModal rule={rule} onClose={() => { this.modalControl() }}></RuleModal>}
      </div>
    );
  }
}
export default Pagemainscene;
