/**
 * 微信分享组件封装
 * 
 * 使用方法：
 * import wxShare from '../../libs/spark_wxshare'
 *  wxShare(options)
 * 
 * 
 * options 参数(可选) 
 * appId: (必填) String, 公众号的唯一标识
 * timestamp: (必填) String, 生成签名的时间戳
 * nonceStr: (必填) String, 生成签名的时间戳
 * signature: (必填) String, 签名
 * jsApiList: (可选) Array, 调用接口列表，默认 ['onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ']
 * title: (可选) String, 分享标题，默认doucment.title
 * desc: (可选) String, 分享描述，默认空
 * shareUrl: (可选) String, 分享链接, 默认当前链接
 * imgUrl: (可选) String, 分享图片，默认空
 * 
 */




const configBuilder = {
    onMenuShareTimeline(config) {
        return {
            title: config.title,
            desc: config.desc,
            link: config.shareUrl,
            imgUrl: config.imgUrl
        }
    },
    onMenuShareAppMessage(config) {
        return {
            title: config.title,
            desc: config.desc,
            link: config.shareUrl,
            imgUrl: config.imgUrl
        }
    },
    onMenuShareQQ(config) {
        return {
            title: config.title,
            desc: config.desc,
            link: config.shareUrl,
            imgUrl: config.imgUrl
        }
    }
}

export default function (config = {}) {
    if (!/MicroMessenger/.test(window.navigator.userAgent)) {
        return false
    }
    if(document.getElementById("jweixin"))
    {
        __handleReady(config);
        return;
    }
    const script = document.createElement('script')
    script.async = 'async';
    script.id="jweixin";
    script.src = `${document.location.protocol}//res.wx.qq.com/open/js/jweixin-1.2.0.js`
    document.getElementsByTagName('head')[0].appendChild(script)

    script.onload = () => {
        __handleReady(config);
    }
}

function __handleReady(config) {
    if (typeof wx !== 'undefined') {
        config.api = config.api || ['onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ']

        // 默认值
        config.imgUrl = config.imgUrl || window.location.protocol + '//mmbiz.qpic.cn/mmbiz_png/UUn1BJoX4UlEbDXKVFqFsSLcmmagib3oQ31FewyWkLfIbpHgw0xYv02zKrgQJNPGytLpudpib45dWZbC0hnawu9Q/0?wx_fmt=png'
        config.shareUrl = config.shareUrl || window.location.href
        config.desc = config.desc || ''
        config.title = config.title || document.title

        wx.config({
            // 开启调试模式,调用的所有api的返回值会在客户端alert出来,若要查看传入的参数,可以在pc端打开,参数信息会通过log打出,仅在pc端时才会打印。
            debug: config.debug || false,

            // 必填,公众号的唯一标识
            appId: config.appid || config.appId || '',

            // 必填,生成签名的时间戳
            timestamp: config.timestamp || '',

            // 必填,生成签名的随机串
            nonceStr: config.nonceStr || '',

            // 必填,签名,见附录1
            signature: config.signature || '',

            // 必填,需要使用的JS接口列表
            jsApiList: [].concat(config.api)
        })

        wx.ready(() => {
            // wx.checkJsApi({
            //    jsApiList: config.api
            //  })
            config.api.forEach(key => {
                wx[key](configBuilder[key](config))
            })
        })
    }
}
