'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api';
import { getPxToken } from '../../libs/spark_gettoken';
import './comnickpanel.less';
import { getModalHoc, Toast } from 'spark-design';
import { ERROR_MESSSAGE } from '../../constant';
import { NetBuried } from '../../NetBuried'

class Comnickpanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      nickName: "",
      modalType: "",
      pass: true,
    };
  }

  /**
   * 提交昵称
   */
  postNickname(nickName) {
    let { onClose } = this.props;
    let { pass } = this.state;
    let str = /^[a-zA-Z0-9\u4e00-\u9fa5]+$/;
    console.log(">......>>>>>.....", str.test(nickName));
    // return;
    if (str.test(nickName)) {
      getPxToken(async token => {
        let { success, message, data, code } = await API.saveNickName({ token: token, nickName: nickName });
        if (success) {
          console.log('接口调用成功', nickName);
          onClose(true);
        } else {
          if (pass) {
            this.setState({
              pass: false
            })
            Toast(ERROR_MESSSAGE(code), 2000)
            setTimeout(() => {
              this.setState({
                pass: true
              })

            }, 2000)
          }
        }
      })
    } else {
      if (pass) {
        this.setState({
          pass: false
        })
        Toast('昵称中不可以输入标点、空格、emoji图案哦', 2000)
        setTimeout(() => {
          this.setState({
            pass: true
          })

        }, 2000)
      }
    }
  }
  showBuried(i) {
    let netBuried = new NetBuried();
    netBuried.showLog(i);
  }
  clickBuried(i) {
    let netBuried = new NetBuried();
    netBuried.clickLog(i);
  }
  onChangeInputValue() {
    let inputValue = document.getElementById("nicknameInput").value;
    console.log('>>>>>.......', inputValue);
    this.setState({
      nickName: inputValue,
    })
  }

  render() {
    let { onClose } = this.props;
    let { nickName } = this.state;
    return (
      <div className="nickpanel ">
        <div className="nickmodal ">
          <img className="nickShadow"></img>
          <img className="nicktitle " src={this.state.resList['18aff2cc-0e6d-4445-9ec6-d303d6539e26'].url} />
          <img className="closebtn " onClick={() => { onClose(false) }} src={this.state.resList['012e2a83-6e78-4f10-9ea7-c26dab7cb711'].url} />
          <img
            className={nickName ? "kai_shi_chuang_jian_huan_qi point3" : "greyBtn"}
            onClick={() => { if (nickName) { this.postNickname(nickName) } }}
            src={this.state.resList['08101bcc-ed92-4893-ae57-b0d2f53294c1'].url}
          />

          <img className="nickinput " src={this.state.resList['4ef09ae1-195d-473e-8eaf-06eac70dd005'].url} />
          <input className="nickInputLab" id="nicknameInput" placeholder="请输入(0/10)" onChange={() => { this.onChangeInputValue() }} maxLength="10"></input>
        </div>
      </div>
    );
  }
}
export default Comnickpanel;
