export default class Guide extends egret.Sprite{

    /**
     * dp 确保已经定位并且没有加入到显示列表中。
     */
    public init(dp:egret.DisplayObject, w:number, h:number):void {
        let container = new egret.Sprite();
        this.touchEnabled=true;
        let bg = new egret.Shape();
        bg.graphics.beginFill(0x000000, 0.7);
        bg.graphics.drawRect(0, 0, w, h);
        bg.graphics.endFill();

        container.addChild(bg);

        container.addChild(dp);

        dp.blendMode = egret.BlendMode.ERASE;

        let renderTexture:egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(container);

        let bitmap:egret.Bitmap = new egret.Bitmap(renderTexture);
        bitmap.pixelHitTest = true;

        this.addChild(bitmap);
    }
}