import Panel from "../../views/Panel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import ToastCtrl from "../../ctrls/toastCtrl";
import NetConst from "../../NetConst";
import { HtmlTextParser } from "../../rulePanel/HtmlTextParser";

export default class TurnTableTipsPanel extends Panel {
    public closeBtn: eui.Button;
    public ok_btn: eui.Button;

    constructor(data?) {
        super();
    }

    start(data?) {
        super.start(data);
        this.data = data || {};
        this.onLoad();

        window['turntableAddTime'] = (res) => {
            if(res.kShareChannel == 'copyURL') {    // 如果是复制链接，则不算分享成功
                return;
            }
            NetManager.ins.addTimesForActivity((success) => {
                if(!success) {
                    PanelCtrl.instance.show(ModuleTypes.TURNTABLE_NOSHARE_PANEL);
                    return;
                }
                // 1.显示Toast  2.更新label
                // this.showToast('分享成功~');
                PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
            }, 2, 1, 1);
        }
    }

    initEvents() {
        this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onShare, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap() {
        super.onTouchTap();
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    onShare() {
        window['iqiyiShare']('', '', '', '', 6);
        // .then(
        //     (res) => {
        //         console.log(res.kShareChannel);
        //         if(res.kShareChannel != 'copyURL') {    // 如果是复制链接，则不算分享成功
        //             NetManager.ins.addTimesForActivity((success) => {
        //                 if(!success) {
        //                     PanelCtrl.instance.show(ModuleTypes.TURNTABLE_NOSHARE_PANEL);
        //                     return;
        //                 }
        //                 // 1.显示Toast  2.更新label
        //                 // this.showToast('分享成功~');
        //                 PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
        //             }, 2, 1, 1);
        //         }
        //     },
        //     (err) => {
        //         console.log(err);
        //     }
        // );
    }

    showToast(msg) {
        ToastCtrl.instance.show(msg);
    };

    removeEvents() {
        this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onShare, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
    }

    public get skinKey() {
        return 'TurnTableTipsPanel'
    }

    // public get groupName() {
    //     return 'turnTablePrize_panel'
    // }

    destroy() {
        super.destroy();
        window['turntableAddTime'] = function(res) {

        };
    }
}