import Panel from "../../views/Panel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import ToastCtrl from "../../ctrls/toastCtrl";

export default class TurnTableNoSharePanel extends Panel {
    public closeBtn: eui.Button;
    public ok_btn: eui.Button;

    constructor(data?) {
        super();
    }

    start(data?) {
        super.start(data);
        this.data = data || {};
        this.onLoad();
    }

    initEvents() {
        this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap() {
        super.onTouchTap();
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    showToast(msg) {
        ToastCtrl.instance.show(msg);
    };

    removeEvents() {
        this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }

    public get skinKey() {
        return 'TurnTableNoSharePanel'
    }

    // public get groupName() {
    //     return 'turnTablePrize_panel'
    // }
}