import Panel from "../../views/Panel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { getlogItem } from "../../getLogItem";
import { LotteryType } from "../../../libs/tw/enum/LotteryType";

export default class TurnTablePrizePanel extends Panel {
    public closeBtn: eui.Button;
    public prizeImg: eui.Image;
    public prizeName: eui.Label;
    public ok_btn: eui.Button;

    constructor(data?) {
        super();
    }

    start(data?) {
        super.start(data);
        this.data = data || {};
        NetManager.ins.showLog(getlogItem(17));
        this.onLoad();
        data.lottery.type == "lucky" && this.data.exposure && NetManager.ins.spmshow(this.data.exposure);
    }

    initEvents() {
        this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap() {
        super.onTouchTap();
        NetManager.ins.clickLog(getlogItem(17));
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    onUse() {
        NetManager.ins.clickLog(getlogItem(17));
        // const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        const lottery = this.data.lottery;
        if(lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            if(lottery.type == "lucky") {
                NetManager.ins.spmclick(this.data.exposure);
            }
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
        } else {
            window.location.href = lottery.link;
        }
    }

    removeEvents() {
        this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.preLoadRes();

    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        // console.log(this.data);
        if(this.data && this.data.lottery) {
            this.prizeImg.source = this.data.lottery.imgUrl;
            this.prizeName.text = this.data.lottery.title;
        }
    }

    protected async preLoadRes() {

        return new Promise(function(resolve, reject) {
            resolve();
        });
    }

    public get skinKey() {
        return 'TurnTablePrizePanel'
    }

    // public get groupName() {
    //     return 'turnTablePrize_panel'
    // }
}