import { NetName } from "../../../libs/tw/enum/NetName";
import ToastCtrl from "../../ctrls/toastCtrl";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";

export const onNotSuccess = function(data?, netname?: NetName) {
    if(!data) {
        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        // showToast('网络异常\n请隔一段时间再尝试');
        return;
    }
    if(data.code == 'E999999999') {//系统级别错误  系统异常，\n请刷新后重试。
        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        // showToast('网络异常\n请隔一段时间再尝试');
    } else if(data.code == 'E100201001') {
        showToast('请登录后重试。');
    } else if(data.code == 'E100201007') {
        showToast('对不起\n您的${CFG.unitName}不足');
    } else if(data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010') {
        showToast('对不起 您的今日游戏次数已达上限 明天再来吧~');
    } else {//其他异常
        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        // showToast('网络异常\n请隔一段时间再尝试');
    }

};

const showToast = function(msg) {
    ToastCtrl.instance.show(msg);
};