import Panel from "../../views/Panel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { getlogItem } from "../../getLogItem";

export default class TurnTableNoPrizePanel extends Panel {
    public ok_btn: eui.Button;
    public closeBtn: eui.Button;

    public get skinKey() {
        return 'TurnTableNoPrizePanel'
    }

    constructor(data?) {
        super();
        this.data = data || {};
    }

    initEvents() {
        this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents() {
        this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap(): any {
        super.onTouchTap();
        NetManager.ins.clickLog(getlogItem(37));
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.preLoadRes();
        this.onLoad();

    }

    start(data?) {

    }

    protected onLoad(): void {
        NetManager.ins.showLog(getlogItem(37));
        this.initUI();
    }

    private initUI(): void {

    }

    protected async preLoadRes() {

    }
}