import Panel from "../../views/Panel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";

export default class TurnTableIDouPanel extends Panel {
    public prizeName:eui.Label;
    public prizeImg:eui.Image;
    public ok_btn:eui.Button;
    public closeBtn:eui.Button;

    constructor(data?) {
        super();
    }

    start(data?) {
        super.start(data);
        this.data = data || {};
        this.onLoad();
    }

    initEvents() {
        this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap() {
        super.onTouchTap();
    }

    touch_tap_ok_btn() {
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    removeEvents() {
        this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        console.log(this.data);
        if(this.data){
            this.prizeImg.source = this.data.imgUrl;
            // this.prizeName.text = this.data.title;
        }
    }

    public get skinKey() {
        return 'TurnTableIDouPanel'
    }

    // public get groupName() {
    //     return 'turnTableIDou_panel'
    // }
}