import { ModuleTypes } from './../types/sceneTypes';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import PanelCtrl from '../ctrls/panelCtrl';
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
import GameConst from '../GameConst';
import { iqiyi } from '../NetConst';
import { GCache } from '../../libs/tc/util/GCache';
import SceneCtrl from '../ctrls/sceneCtrl';
import Toast from '../views/Toast';
import { TwFun } from '../../libs/tw/util/TwFun';
import SVGACtrl from '../ctrls/svgaCtrl';


export default class StartScene extends Scene {
   
    public mainScro:eui.Scroller;
    public mainGroup:eui.Group;

    public BGimg:eui.Image;
    public ruleBtn:eui.Button;
    public prizeBtn:eui.Button;
    public getcard:eui.Button;
    public getcardtimes:eui.Label;
    public mycard:eui.Image;

    public task1lab:eui.Label;
    public task1con:eui.Label;
    public task1Btn:eui.Button;
    public task2lab:eui.Label;
    public task2con:eui.Label;
    public task2Btn:eui.Button;
    public task3lab:eui.Label;
    public task3con:eui.Label;
    public task3Btn:eui.Button;
    public task4lab:eui.Label;
    public task4con:eui.Label;
    public task4Btn:eui.Button;

    public luckypan:eui.Group;
    public hongbao:eui.Group;
    public duobao:eui.Group;
    public playbg:eui.Image;
    public hongbao2:eui.Group;
    public hongbao3:eui.Group;

    public card0Group:eui.Group;
    public card0bg:eui.Image;
    public card0num:eui.Label;
    public card1Group:eui.Group;
    public card1bg:eui.Image;
    public card1num:eui.Label;
    public card2Group:eui.Group;
    public card2bg:eui.Image;
    public card2num:eui.Label;
    public card3Group:eui.Group;
    public card3bg:eui.Image;
    public card3num:eui.Label;
    public card4Group:eui.Group;
    public card4bg:eui.Image;
    public card4num:eui.Label;
    public card5Group:eui.Group;
    public card5bg:eui.Image;
    public card5num:eui.Label;
    public card6Group:eui.Group;
    public card6bg:eui.Image;
    public card6num:eui.Label;
    public card7Group:eui.Group;
    public card7bg:eui.Image;
    public card7num:eui.Label;
    public card8Group:eui.Group;
    public card8bg:eui.Image;
    public card8num:eui.Label;

    public btnlight:eui.Image;
    public lightMask:eui.Rect;

    public text1:eui.Label;
    public text2:eui.Label;
    public text3:eui.Label;
    public line:eui.Image;

    public tu1:eui.Image;
    public tu2:eui.Image;
    public tu3:eui.Image;

    public labtipbg:eui.Image;
    public labtip:eui.Label;
    public labtipMask:eui.Rect;

    public yi:eui.Group;

    public nownum:number = 0;

    public static instance:StartScene;

    private composed:boolean = false;

    protected get skinKey() { return 'Start' }

    private carddata:any;

    private sceneBtnExposure:any;
    private jikaBtnBtnExposure:any;
    private zengjiaBtnBtnExposure:any;
    private task0Exposure:any;
    private task1Exposure:any;
    private task2Exposure:any;
    private task3Exposure:any;
    private task4Exposure:any;
    private task5Exposure:any;
    private ruleBtnBtnExposure:any;
    private prizeBtnBtnExposure:any;
    private huanduanBtnExposure:any;
    constructor(data){
        super();
        console.log("v 1.1");
        this.initUI(data);
        this.initBuired();
        this.carddata = data.carddata;
        this.btnlight.mask = this.lightMask;
        this.btnlight.touchEnabled = false;
        if(GameConst.isIOS()){

        }else{
            // this.mainScro.y = -;
        }
        // huanbeiNet.getProjectUserInfo((s)=>{
        //     if(!s){
        //         ToastCtrl.instance.show("网络异常，请重试~");
        //         return;
        //     }
        //     this.consumerCredits = DataManager.ins.getData("getProjectUserInfo").data.consumerCredits;

        // },window['pageId'])
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)
        
    }

    onSkinComplete() {
        StartScene.instance = this;
        super.onSkinComplete();
        
        // this.initUI();
    }

    onEnterFrame(){
        // this.light.rotation+= 2
        this.tu1.rotation+=0.5;
        this.tu2.rotation+=0.5;
        this.tu3.rotation+=0.5;
    }

    initBuired() {
        let sceneDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let sceneDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.sceneBtnExposure = Buried.createExposure(sceneDpmOut, sceneDcmOut);

        NetManager.ins.showLog(this.sceneBtnExposure);
        
        let jikaBtnDpmOut = Buried.connectDpm(110, 18, 1); // 点击埋点   
        let jikaBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.jikaBtnBtnExposure = Buried.createExposure(jikaBtnDpmOut, jikaBtnDcmOut);

        NetManager.ins.showLog(this.jikaBtnBtnExposure);

        

        let ruleBtnDpmOut = Buried.connectDpm(110, 15, 1); // 点击埋点   
        let ruleBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.ruleBtnBtnExposure = Buried.createExposure(ruleBtnDpmOut, ruleBtnDcmOut);
        NetManager.ins.showLog(this.ruleBtnBtnExposure);
        

        let prizeBtnDpmOut = Buried.connectDpm(110, 16, 1); // 点击埋点   
        let prizeBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.prizeBtnBtnExposure = Buried.createExposure(prizeBtnDpmOut, prizeBtnDcmOut);

        NetManager.ins.showLog(this.prizeBtnBtnExposure);
        if(GameConst.getQueryString("signEnt")){
            let huanduanDpmOut = Buried.connectDpm(110, 42, 1); // 点击埋点   
            let huanduanDcmOut = Buried.connectDcm(202, parseInt(GameConst.getQueryString("signEnt")), 0); // 曝光埋点
            this.huanduanBtnExposure = Buried.createExposure(huanduanDpmOut, huanduanDcmOut);

            NetManager.ins.showLog(this.huanduanBtnExposure);
        }
        
    }


    initUI(data) {
        // let data = {carddata:carddata,numdata:numdata,collectdata:collectdata,taskdata:taskdata,taskY:false}
        // this.mainScro.height = GameConst.stage.stageHeight;
        document.body.style.overflow = "hidden";
        
        this.mainScro.height = 750/window.innerWidth*window.innerHeight;
        this.mainScro.width = 1624/window.innerHeight*window.innerWidth;

        let arr:any[] = [];
        //已有卡片对应显示
        if(data.carddata){
            for(let i = 0;i<data.carddata.length;i++){
                if(data.carddata[i].type == 2){
                    arr.push(data.carddata[i]);
                }
            }
            for(let n = 0; n<arr.length;n++){
                
                if(arr[n].num == 0){
                    this["card"+n+"bg"].source = "";
                    this["card"+n+"Group"].visible = false;
                }else if(arr[n].num == 1){
                    this["card"+n+"bg"].source = arr[n].image;
                    this["card"+n+"Group"].visible = false;
                    this["card"+n+"num"].text = arr[n].num;
                }else{
                    this["card"+n+"bg"].source = arr[n].image;
                    this["card"+n+"Group"].visible = true;
                    this["card"+n+"num"].text = arr[n].num;
                }
            }
        }
        //按钮显示
        if(data.collectdata>0){
            this.getcardtimes.text = "立即集卡*"+data.collectdata;
            this.onTap(this.getcardtimes,this.onTap_getCard);
            this.btnlight.visible = true;
            this.initAni()
        }else{
            this.getcardtimes.text = "增加集卡次数";
            this.clearTap(this.getcardtimes,this.onTap_getCard);
            this.onTap(this.getcardtimes,this.onTap_getTask)
            this.btnlight.visible = false;
            let zengjiaBtnDpmOut = Buried.connectDpm(110, 19, 1); // 点击埋点   
            let zengjiaBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.zengjiaBtnBtnExposure = Buried.createExposure(zengjiaBtnDpmOut, zengjiaBtnDcmOut);

            NetManager.ins.showLog(this.zengjiaBtnBtnExposure);
        }

        if(data.taskY){
            this.mainScro.viewport.scrollV = 1072;
        }

        //显示任务状态
        for(let i = 0;i<data.taskdata.length;i++){
            let taskDpmOut = Buried.connectDpm(110, 26, 1); // 点击埋点   
            let taskDcmOut = Buried.connectDcm(202, data.taskdata[i].code, 0); // 曝光埋点
            this["task"+data.taskdata[i].code+"Exposure"] = Buried.createExposure(taskDpmOut, taskDcmOut);

            NetManager.ins.showLog(this["task"+data.taskdata[i].code+"Exposure"]);
            if(data.taskdata[i].code == 2){
                this.task1lab.text = "邀请好友助力（"+data.taskdata[i].num+"/5）"
                if(data.taskdata[i].num<5){
                    this.onTap(this.task1Btn,this.onTap_duHelp);
                }else{
                    this.clearTap(this.task1Btn,this.onTap_duHelp)
                    this.task1Btn.touchEnabled = false;
                    this.task1Btn.touchChildren = false;
                    this.task1Btn.icon = "taskfinish_png";
                }
            }
            if(data.taskdata[i].code == 0){
                if(data.taskdata[i].num == 0){
                    this.onTap(this.task2Btn,this.onTap_order);
                }else{
                    this.clearTap(this.task2Btn,this.onTap_order);
                    this.task2Btn.touchEnabled = false;
                    this.task2Btn.touchChildren = false;
                    this.task2Btn.icon = "taskfinish_png";
                    
                }
            }
            if(data.taskdata[i].code == 3){
                if(data.taskdata[i].num == 0){
                    this.onTap(this.task3Btn,this.onTap_watch);
                }else{
                    this.clearTap(this.task3Btn,this.onTap_watch)
                    this.task3Btn.touchEnabled = false;
                    this.task3Btn.touchChildren = false;
                    this.task3Btn.icon = "taskfinish_png";
                }
            }
            if(data.taskdata[i].code == 4){
                this.task2lab.text = "赠送一张卡给好友"
                if(data.taskdata[i].num == 0){
                    this.task2Btn.icon = "taskbtn6_png";
                    this.onTap(this.task2Btn,this.onTap_give);
                }else{
                    this.clearTap(this.task2Btn,this.onTap_give);
                    this.task2Btn.touchEnabled = false;
                    this.task2Btn.touchChildren = false;
                    this.task2Btn.icon = "taskfinish_png";
                }
            }
            if(data.taskdata[i].code == 1){
                if(data.taskdata[i].num == 0){
                    this.onTap(this.task4Btn,this.onTap_fouce);
                }else{
                    
                    this.clearTap(this.task4Btn,this.onTap_fouce);
                    this.task4Btn.touchEnabled = false;
                    this.task4Btn.touchChildren = false;
                    this.task4Btn.icon = "taskfinish_png";
                    
                }
            }
            if(data.taskdata[i].code == 5){
                this.task4lab.text = "获得好友赠送的一张卡"
                if(data.taskdata[i].num == 0){
                    this.task4Btn.icon = "taskbtn5_png";
                    this.onTap(this.task4Btn,this.onTap_ask);
                }else{
                    this.clearTap(this.task4Btn,this.onTap_ask);
                    this.task4Btn.touchEnabled = false;
                    this.task4Btn.touchChildren = false;
                    this.task4Btn.icon = "taskfinish_png";
                }
            }
        }
        //链接进来如果有赠卡or收卡请求
        // let carddata = {data:data,datatype:1};
        // PanelCtrl.instance.show(ModuleTypes.GETCARD_PANEL,carddata);
        // iqiyiShare(type,shareCode,cardId,token)
        //type =1 助力，type = 2赠卡，type=3 索卡，type =4日常分享
        console.log("type = "+GameConst.getQueryString("type"))
        if(!GameConst.isfirst){
            console.log("here")
            if(GameConst.getQueryString("type")){
                let type:any = GameConst.getQueryString("type")
                if(type == 2 || type ==3){
                    let data = {id:GameConst.getQueryString("cardId")}
                    let carddata = {data:data,datatype:type};
                    PanelCtrl.instance.show(ModuleTypes.GETCARD_PANEL,carddata);
                    GameConst.isfirst = true
                }
                
            }
        }
        

        
        //更多玩法对应链接
        this.geturl(data);

        //集齐9张爱豆卡合成
        if(data.carddata){
            for(let i = 0;i<data.carddata.length;i++){
                if(data.carddata[i].type == 0 && data.carddata[i].num > 0){
                    break;
                }
                if(data.carddata[i].type == 2 ) {
                    if(data.carddata[i].num>0){
                        this.composed = true;
                    }else{
                        this.composed = false;
                        break;
                    }
                    
                }
            }
            if(this.composed){
                SVGACtrl.instance.load("hecheng","hecheng.svga");
                PanelCtrl.instance.show2(ModuleTypes.COMPOSE_PANEL,data.carddata);
            }
        }

        //红包开奖
        let now = new Date();
        //2019/12/07 22:00:00  1575648000000
        
        if(now.getTime()>window['hongbaokaijiang']){
            this.btnlight.visible = false;
            this.getcard.touchChildren = false;
            this.getcard.touchEnabled = false;
            this.getcardtimes.touchEnabled = false;
            this.task1Btn.touchChildren = false;
            this.task1Btn.touchEnabled = false;
            this.task2Btn.touchChildren = false;
            this.task2Btn.touchEnabled = false;
            this.task3Btn.touchChildren = false;
            this.task3Btn.touchEnabled = false;
            this.task4Btn.touchChildren = false;
            this.task4Btn.touchEnabled = false;
            this.setColor2(this.getcard);
            this.setColor2(this.getcardtimes);
            this.setColor2(this.task1Btn);
            this.setColor2(this.task2Btn);
            this.setColor2(this.task3Btn);
            this.setColor2(this.task4Btn);
            if(!GCache.readCache("hongbao")){
                GCache.writeCache("hongbao",true);
                //接口
                iqiyi.getOpenResult((s)=>{
                    if(!s){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getOpenResult").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getOpenResult").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return
                    }
                    let data = DataManager.ins.getData("getOpenResult").data;
                    if(data){
                        PanelCtrl.instance.show(ModuleTypes.HONGBAO_PANEL,data);
                    }
                    
                },window["CFG"].activityId)

                
            }
        }
        //红包雨替换
        // if(now.getTime()>1575561600000){
        if(now.getTime()>window['hongbaoyutime']){
            this.playbg.source = "playbg22_png"
            this.hongbao.visible = false;
            this.hongbao2.visible = true;
            this.hongbao3.visible = false
            this.onTap(this.hongbao2,this.onTap_hongbao);
        }else{
            this.playbg.source = "playbg2_png"
            this.hongbao.visible = true;
            this.hongbao2.visible = false;
            this.hongbao3.visible = false
        }
        if(now.getTime()>window['hongbaoyuendtime']){
            this.playbg.source = "playbg2_png"
            this.hongbao.visible = false;
            this.hongbao2.visible = false;
            this.hongbao3.visible = true;
            this.clearTap(this.hongbao2,this.onTap_hongbao);
        }
        

        //人数显示
        this.setColor(this.line);
        this.text2.text = data.numdata+"人";
        this.text2.x = this.text1.x+this.text1.width;
        this.text3.x = this.text2.x+this.text2.width;
        this.line.x = this.text2.x;
        this.line.width = this.text2.width;
        this.nownum = data.numdata;
        
        setInterval(()=>{
            this.updateNum();
        },60000);
        //////////////////////////////////////////////////
        // PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
        //////////////////////////////////////////////////

        //播报轮询每天一次
        // if(!GCache.readCache("day"+now.getDate())){
        //     GCache.writeCache("day"+now.getDate(),true)
            this.labtip.mask = this.labtipMask;
            this.labtip.x = 580;
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterTips, this)
        // }else{
        //     this.labtipbg.visible = false
        //     this.labtip.visible = false
        //     this.labtipMask.visible = false
        // }
    }
    onEnterTips(){
        this.labtip.x--
        if(this.labtip.x<-245){
            // this.labtipbg.visible = false
            // this.labtip.visible = false
            // this.labtipMask.visible = false
            this.labtip.x = 580;
        }
    }
    geturl(data){
        this.onTap(this.luckypan,this.onTap_luckypan);
        
        this.onTap(this.duobao,this.onTap_duobao);
    }
    //按钮动效
    initAni() {
        // this.btnlight.visible = true;
        egret.Tween.get(this.btnlight)
        .set({x:120,y:845,alpha:1})
        .to({x:478,y:845},1670)
        .to({alpha:0})
        .wait(1000)
        .call(()=>{
            this.initAni()
        })
    }
    
    updateNum(){
        iqiyi.getCompletedNum((s)=>{
            if(!s){
                if(DataManager.ins.getData("getCompletedNum").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
            }else{
                console.log('刷新人数');
                let data = DataManager.ins.getData('getCompletedNum').data;
                this.setColor(this.line);
                this.text2.text = data+"人";
                this.text2.x = this.text1.x+this.text1.width;
                this.text3.x = this.text2.x+this.text2.width;
                this.line.x = this.text2.x;
                this.line.width = this.text2.width;
            }
            
        },window["CFG"].activityId)
    }
    setColor(group) {
        let colorMatrix = [
            1, 0, 0, 0, 252,
            0, 1, 0, 0, 255,
            0, 0, 1, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    setColor2(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    onTap_getCard(){
        Waiting.instance.show()
        NetManager.ins.clickLog(this.jikaBtnBtnExposure)
        iqiyi.collect((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("collect").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("collect").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let data = DataManager.ins.getData('collect').data;
            if(data.orderId){
                iqiyi.getOrderStatus((ss)=>{
                    if(!ss){

                        return;
                    }
                    let lottery = DataManager.ins.getData("getOrderStatus").data.lottery;
                    let carddata :any= {};
                    if(data.id){
                        for(let i = 0; i<DataManager.ins.getData('getAllCards').data.length;i++){
                            if(data.id == DataManager.ins.getData('getAllCards').data[i].id){
                                SVGACtrl.instance.load("chouka",DataManager.ins.getData('getAllCards').data[i].mark+".svga");
                                carddata = {data:data,wuyong:99,datatype:1,lottery:lottery};
                            }
                        }
                        
                    }else{
                        let num = Math.floor(Math.random()*6+1);
                        SVGACtrl.instance.load("chouka","wuyong"+num+".svga");
                        carddata = {data:data,wuyong:num,datatype:1,lottery:lottery};
                    }
                
                    PanelCtrl.instance.show2(ModuleTypes.GETCARD_PANEL,carddata);
                },data.orderId)
            }else{
                let carddata :any= {};
                    if(data.id){
                        for(let i = 0; i<DataManager.ins.getData('getAllCards').data.length;i++){
                            if(data.id == DataManager.ins.getData('getAllCards').data[i].id){
                                SVGACtrl.instance.load("chouka",DataManager.ins.getData('getAllCards').data[i].mark+".svga");
                                carddata = {data:data,wuyong:99,datatype:1};
                            }
                        }
                        
                    }else{
                        let num = Math.floor(Math.random()*6+1);
                        SVGACtrl.instance.load("chouka","wuyong"+num+".svga");
                        carddata = {data:data,wuyong:num,datatype:1};
                    }
                
                    PanelCtrl.instance.show2(ModuleTypes.GETCARD_PANEL,carddata);
            }
        },window["CFG"].activityId)
    }
    onTap_getTask(){
        NetManager.ins.clickLog(this.zengjiaBtnBtnExposure)
        this.mainScro.viewport.scrollV = 1072;
    }
    

    initEvents() {
        super.initEvents();
        this.onTap(this.mycard,this.onTap_mycard);
        this.onTap(this.ruleBtn,this.onTap_ruleBtn);
        this.onTap(this.prizeBtn,this.onTap_prizeBtn)
        GameConst.BtnAni(this.getcard,this.getcardtimes);
        
    }
    onTap_ruleBtn(){
        NetManager.ins.clickLog(this.ruleBtnBtnExposure)
        Waiting.instance.show()
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_prizeBtn(){
        NetManager.ins.clickLog(this.prizeBtnBtnExposure)
        Waiting.instance.show()
        window.location.href = TwFun.getRecordUrl("00");
    }
    onTap_luckypan(){
        Waiting.instance.show()
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    onTap_hongbao(){
        Waiting.instance.show()
        window.location.href = window['hongbaoyu'];
    }

    onTap_duobao(){
        Waiting.instance.show()
        window.location.href = window['duobao'];
    }
    
    onTap_mycard(){
        Waiting.instance.show()
        iqiyi.getCompletedNum((s)=>{
            Waiting.instance.hide()
            let numdata:any = 0;
            if(!s){
                numdata = this.nownum;
            }else{
                numdata = DataManager.ins.getData('getCompletedNum').data;
                
            }
                let carddata = DataManager.ins.getData('getAllCards').data;
                let data = {numdata:numdata,carddata:carddata};
                SceneCtrl.instance.change(ModuleTypes.MYCARD_SCENE,data);
        },window["CFG"].activityId)
        
    }

    onTap_duHelp(){
        NetManager.ins.clickLog(this.task2Exposure)
        // iqiyiShare(type,shareCode,cardId,token)
        //type =1 助力，type = 2赠卡，type=3 收卡，type =4日常分享
        Waiting.instance.show()
        iqiyi.getShareCode((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试")
                if(DataManager.ins.getData("getShareCode").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getShareCode").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            let num = Math.floor(Math.random()*9+2);
            let cardId = this.carddata[num].id;
            window['iqiyiShare'](1,DataManager.ins.getData("getShareCode").data,cardId,null,2);
        },window["CFG"].activityId,0)
        // iqiyi.doTask((s)=>{
        //     if(!s){
        //         if(DataManager.ins.getData("doTask").desc){
        //             ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
        //         }else{
        //             PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //         }
        //         return
        //     }
        //     ToastCtrl.instance.show("助力成功，送你一次集卡机会");
         
        //     iqiyi.getCollectNum((ss)=>{
        //         if(!s){
        //             if(DataManager.ins.getData("getCollectNum").desc){
        //                 ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
        //             }else{
        //                 PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //             }
        //             return
        //         }
        //         this.updataTimes(DataManager.ins.getData("getCollectNum").data);
        //     },window["CFG"].activityId)
        // },window["CFG"].activityId,2)
        
    }

    onTap_order(){
        NetManager.ins.clickLog(this.task0Exposure)
        //js
        Waiting.instance.show()
        
        
        // setTimeout(()=>{
            iqiyi.doTask((s)=>{
                window.location.href = "http://www.iqiyi.com/kszt_phone/2020aqyjjzyh5.html";
                Waiting.instance.hide()
                if(!s){
                    if(DataManager.ins.getData("doTask").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return
                }
                // window['order']();
                setTimeout(()=>{
                    ToastCtrl.instance.show("预约成功，送你一次集卡机会");
                    this.clearTap(this.task2Btn,this.onTap_order);
                    this.task2Btn.touchEnabled = false;
                    this.task2Btn.touchChildren = false;
                    this.task2Btn.icon = "taskfinish_png";
                    iqiyi.getCollectNum((ss)=>{
                        if(!s){
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return
                        }
                        this.updataTimes(DataManager.ins.getData("getCollectNum").data);
                    },window["CFG"].activityId)
                },2000)
            },window["CFG"].activityId,0)
        // },2000)
        
    }
    onTap_watch(){
        NetManager.ins.clickLog(this.task3Exposure)
        //链接跳转
        Waiting.instance.show()
        console.log("观看链接"+window['watchurl'])
        
        Waiting.instance.hide()
        // setTimeout(()=>{
            iqiyi.doTask((s)=>{
                window.location.href = window['watchurl']
                if(!s){
                    if(DataManager.ins.getData("doTask").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return
                }
                
                setTimeout(()=>{
                    ToastCtrl.instance.show("已观看，送你一次集卡机会");
                    this.clearTap(this.task3Btn,this.onTap_watch);
                    this.task3Btn.touchEnabled = false;
                    this.task3Btn.touchChildren = false;
                    this.task3Btn.icon = "taskfinish_png";
                    iqiyi.getCollectNum((ss)=>{
                        if(!s){
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return
                        }
                        this.updataTimes(DataManager.ins.getData("getCollectNum").data);
                    },window["CFG"].activityId)
                },2000)
                
            },window["CFG"].activityId,3)
        // },2000)
        
    }
    onTap_fouce(){
        NetManager.ins.clickLog(this.task1Exposure)
        //链接跳转
        Waiting.instance.show()
        
        
        // setTimeout(()=>{
            iqiyi.doTask((s)=>{
                window.location.href = "https://weibo.com/u/5541658233"
                Waiting.instance.hide()
                if(!s){
                    if(DataManager.ins.getData("doTask").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return
                }
                
                setTimeout(()=>{
                    ToastCtrl.instance.show("已关注，送你一次集卡机会");
                    this.clearTap(this.task4Btn,this.onTap_fouce);
                    this.task4Btn.touchEnabled = false;
                    this.task4Btn.touchChildren = false;
                    this.task4Btn.icon = "taskfinish_png";
                    iqiyi.getCollectNum((ss)=>{
                        if(!s){
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return
                        }
                        this.updataTimes(DataManager.ins.getData("getCollectNum").data);
                    },window["CFG"].activityId)
                },2000)
            },window["CFG"].activityId,1)
        // },2000)
        
    }
    onTap_give(){
        NetManager.ins.clickLog(this.task4Exposure)
        this.onTap_mycard();
        // iqiyi.doTask((s)=>{
        //     if(!s){
        //         if(DataManager.ins.getData("doTask").desc){
        //             ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
        //         }else{
        //             PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //         }
        //         return
        //     }
        //     ToastCtrl.instance.show("助力成功，送你一次集卡机会");
         
        //     iqiyi.getCollectNum((ss)=>{
        //         if(!s){
        //             if(DataManager.ins.getData("getCollectNum").desc){
        //                 ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
        //             }else{
        //                 PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //             }
        //             return
        //         }
        //         this.updataTimes(DataManager.ins.getData("getCollectNum").data);
        //     },window["CFG"].activityId)
        // },window["CFG"].activityId,4)
    }
    onTap_ask(){
        NetManager.ins.clickLog(this.task5Exposure)
        this.onTap_mycard();
        // iqiyi.doTask((s)=>{
        //     if(!s){
        //         if(DataManager.ins.getData("doTask").desc){
        //             ToastCtrl.instance.show(DataManager.ins.getData("doTask").desc)
        //         }else{
        //             PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //         }
        //         return
        //     }
        //     ToastCtrl.instance.show("助力成功，送你一次集卡机会");
         
        //     iqiyi.getCollectNum((ss)=>{
        //         if(!s){
        //             if(DataManager.ins.getData("getCollectNum").desc){
        //                 ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
        //             }else{
        //                 PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
        //             }
        //             return
        //         }
        //         this.updataTimes(DataManager.ins.getData("getCollectNum").data);
        //     },window["CFG"].activityId)
        // },window["CFG"].activityId,5)
    }

    
    updataTimes(data){
        if(data>0){
            this.getcardtimes.text = "立即集卡*"+data;
            this.onTap(this.getcardtimes,this.onTap_getCard);
        }else{
            this.getcardtimes.text = "增加集卡次数";
            this.clearTap(this.getcardtimes,this.onTap_getCard);
            this.onTap(this.getcardtimes,this.onTap_getTask)
            this.btnlight.visible = false;
        }
    }
    
}