import Panel from "../views/Panel";
import StartScene from "../startScene/StartScene";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";


export default class RecordPanel extends Panel {

    get skinKey() { return "Record" }

    public scroller:eui.Scroller;
    public group0:eui.Group;
    public closeBtn:eui.Button;


    constructor(data) {
        super();
        this.initUI(data)
    }
    initUI(data){
        if(data){
            if(data.length>0){
                for(let i = 0;i<data.length;i++){
                    let records = new eui.Label();
                    records.text = data[i].desc;
                    records.size = 36;
                    records.y = i*75;
                    records.textColor = 0xb1d1e7;
                    this.group0.addChild(records);
                    let recordnum = new eui.Label();
                    let num:any = data[i].cardNum;
                    if(num>0){
                        num = "+"+num +"张"
                    }else{
                        num =Math.abs(num);
                        num = "- "+num+"张"
                    }
                    recordnum.text = num;
                    recordnum.size = 36;
                    recordnum.x = 390;
                    recordnum.y = i*75;
                    recordnum.textColor = 0xb1d1e7;
                    this.group0.addChild(recordnum);
                }
            }else{
                let tips = new eui.Label();
                    tips.text = "暂无获取";
                    tips.size = 36;
                    tips.width = this.scroller.width;
                    tips.textColor = 0xb1d1e7;
                    tips.textAlign = "center"
                    this.group0.addChild(tips);
            }
        }
        
        
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        
    }

    onTap_closeBtn(e) {
        // huanbeNet.getTask((s)=>{
        //     if(!s){
        //         ToastCtrl.instance.show("活动太火爆了，请稍后再来~")
        //     }
        //     this.hidePanel();
        //     let data = DataManager.ins.getData("getTask").data;
        //     StartScene.instance.updateData(data);
        // },window['projectId'],true)
        this.hidePanel();
        
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
    }

}