
import Scene from "../views/Scene";
import GameConst from "../GameConst";
import { ModuleTypes } from '../types/sceneTypes';
import NetConst from '../NetConst';
import ToastCtrl from '../ctrls/toastCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import PanelCtrl from '../ctrls/panelCtrl';
import Waiting from "../waiting/Waiting";
import SceneCtrl from "../ctrls/sceneCtrl";

export default class PlayScene extends Scene {

    protected get skinKey() { return "Play" }

    public bg1:eui.Image;
    public bg2:eui.Image;
    public runcar:eui.Image;
    public goleft:eui.Image;
    public goright:eui.Image;
    public blocknum2:eui.Label;
    public cakenum2:eui.Label;
    public runnum2:eui.Label;
    public distancenum:eui.Label;
    public playGroup:eui.Group;
    
    public distance:number = 0;
    public speed:number = 0;
    public line:number = 2;
    public touchtime:number = 0;
    public createtime:number = 0;
    public collision:number = 0;
    public getcake:number = 0
    public prefabtarget:any;
    private prefabPool: any[] = [];
    public isend:boolean = false;
    public static instance:PlayScene;
    constructor() {
        super();
        //this.initUI();
        PlayScene.instance = this;
        this.guideCount();
    }

    // 引导倒计时 3 2 1 go!
    private guideCount() {
        this.runnum2.text = "已行驶:0km";
        this.blocknum2.text = "路障:0个"
        this.cakenum2.text = "月饼:0个"
        this.distancenum.visible = false;
        PanelCtrl._instance.show(ModuleTypes.COUNTDOWN_PANEL);
        
    }
    //间隔时间
    public interval:number = window['interval'];
    onEnterFrame() {
        let i:number = Math.floor(this.distance /window['kilometer']);
        switch(i){
            case 0:
                this.speed = window['speed'];
                break;
            case 1:
                this.speed = window['speed'];
                break;
            case 2:
                this.speed = window['speed']+window['speedRate'];
                this.interval = 1500;
                break;
            case 3:
                //this.speed = window['speed'];
                break;
            case 4:
                //this.speed = window['speed'];
                break;
            case 5:
                this.speed = window['speed']+(window['speedRate']*2);
                this.interval = 1200;
                break;
            default:
                if(i%5==0){
                    this.speed = window['speed']+window['speedRate']*(i/5+1);
                    if(this.interval>500){
                        this.interval = 1200 -window['cutinterval']*(i/5);
                    }
                }
                break;                
        }
       
        this.showGuidepost(i);
        
        this.distance +=this.speed;
        this.bg1.y +=this.speed;
        this.bg2.y +=this.speed;
        if(this.bg1.y>=this.bg1.height){
            this.bg1.y = this.bg2.y-1622; 
        }
        if(this.bg2.y>=this.bg2.height){
            this.bg2.y = this.bg1.y-1622;
        }
        this.runnum2.text = "已行驶:"+i+"km";
        // 设置速度  超出屏幕移除  
        if(this.isinitPrefab && this.prefabPool.length >0){
            if(this.collision<3){
                for(let i=this.prefabPool.length-1;i>=0;i--){
                    this.prefabPool[i].y += this.speed;
                    if(this.prefabPool[i].y>1624){
                        if (this.prefabPool[i].$parent) {
                            this.playGroup.removeChild(this.prefabPool[i]);
                        }
                        GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                    }else if(this.prefabPool[i].y+this.prefabPool[i].height>=this.runcar.y && this.prefabPool[i].lane == this.line && this.prefabPool[i].y<= this.runcar.y+this.runcar.height){
                        if(this.prefabPool[i].type == 1){
                            if(this.collision<2){
                                const ele = this.prefabPool[i];
                                this.playGroup.addChild(ele);
                                GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                                egret.Tween.get(ele)
                                    .to({rotation:180,x:ele.x+300,alpha:0},300)
                                    .call(()=>{
                                        this.playGroup.removeChild(ele);
                                })
                                this.collision+=1;
                                console.log("collision"+ this.collision)
                            }else{
                                this.collision+=1;
                                this.speed = 0;
                                this.gameOver();
                            }
                            
                                //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                            
                        }else if(this.prefabPool[i].type == 2){
                            if(this.collision<2){
                                const ele = this.prefabPool[i];
                                this.playGroup.addChild(ele);
                                GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                                egret.Tween.get(ele)
                                    .to({rotation:180,x:ele.x+300,alpha:0,scaleX:0.6,scaleY:0.6},300)
                                    .call(()=>{
                                        this.playGroup.removeChild(ele);
                                        
                                })
                                this.collision+=1;
                                console.log("collision"+ this.collision)
                            }else{
                                this.collision+=1;
                                this.speed = 0;
                                this.gameOver();
                            }
                            
                                //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                            
                        }else if(this.prefabPool[i].type == 3){
                            if(this.prefabPool[i].y+(this.prefabPool[i].height*2/3)>=this.runcar.y && this.prefabPool[i].lane == this.line){
                                const ele = this.prefabPool[i];
                                this.playGroup.addChild(ele);
                                GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                                egret.Tween.get(ele)
                                    .set({scaleX:1.1,scaleY:1.1})
                                    .to({x:20,y:140,alpha:0,scaleX:0.6,scaleY:0.6},500)
                                    .call(()=>{
                                        this.playGroup.removeChild(ele);
                                })
                                    //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                                this.getcake += 2; 
                            }
                            
                        }
                    }
                }
            
            }else{
                this.speed = 0;
                this.gameOver();
            }
                            
        }
        //生成新障碍
        let now = Date.now();
        if(now - this.createtime>this.interval){
            let randomtype:number = Math.floor(Math.random()*3)+1;
            let randomlane:number = Math.floor(Math.random()*3)+1;
            let prefab = this.creatPrefab(randomtype,randomlane);
            this.prefabPool.push(prefab);
            this.playGroup.addChildAt(prefab,1);
            this.createtime = now;
        }
        this.blocknum2.text = "路障:"+this.collision+"个";
        this.cakenum2.text = "月饼:"+this.getcake+"个";

    }

    showGuidepost(num:number){
        if(num<5 || num%5 == 4){
            if(this.distance+this.runcar.y >= (num+1) * window['kilometer']){
                if(this.distancenum.visible){

                }else{
                    this.distancenum.visible = true;
                    this.distancenum.text = (num+1) + "km";
                    this.distancenum.y = 0;
                }
                
            }
        }
        
        this.distancenum.y += this.speed;
        if(this.distancenum.y>GameConst.stage.stageHeight){
            this.distancenum.visible = false;
        }
    }

    getEnterFrame() {
        this.initPrefab()
        this.onTap(this.goleft,this.onTap_goleft);
        this.onTap(this.goright,this.onTap_goright);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);

    }

    onTap_goleft(){
        let now = Date.now();
        if(now-this.touchtime>200){
            console.log("goleft");
            if(this.line>1){
                this.line -= 1;
                
            }
            console.log(this.line);
            if(this.line == 1){
                egret.Tween.get(this.runcar)
                .to({x:82},200)
            }else if(this.line==2){  
                egret.Tween.get(this.runcar)
                .to({x:295},200)
            }
            this.touchtime = now;
        }
        
        
    }
    onTap_goright(){
        console.log("goright");
        let now = Date.now();
        if(now-this.touchtime>200){
            if(this.line<3){
                this.line += 1;
            }
            
            if(this.line == 2){
                egret.Tween.get(this.runcar)
                .to({x:295},200)
            }else if(this.line==3){  
                egret.Tween.get(this.runcar)
                .to({x:509},200)
            }
            this.touchtime = now;
        }
    }

    public isinitPrefab:boolean = false;
    initPrefab(){
        let block1 = this.creatPrefab(1,1);
        block1.y = 430;
        this.prefabPool.push(block1);
        this.playGroup.addChildAt(block1,1);
        let block2 = this.creatPrefab(2,3);
        block2.y = 460;
        this.prefabPool.push(block2);
        this.playGroup.addChildAt(block2,1);
        let cake = this.creatPrefab(3,2);
        cake.y = 56;
        this.prefabPool.push(cake);
        this.playGroup.addChildAt(cake,1);

        this.isinitPrefab = true;
    }

    creatPrefab(id:number,lane:number){
        let prefab:any;
        if(id == 1){
            prefab = new eui.Component();
            prefab.skinName = "roadblockSkin";
            if(lane == 1){
                prefab.x = 82;
            }else if(lane == 2){
                prefab.x = 308;
            }else if(lane == 3){
                prefab.x = 536;
            }
            prefab.y = 0;
        }else if(id == 2){
            prefab = new eui.Component();
            prefab.skinName = "roadcarSkin";
            if(lane == 1){
                prefab.x = 110;
            }else if(lane == 2){
                prefab.x = 330;
            }else if(lane == 3){
                prefab.x = 550;
            }
            prefab.y = 0;
        }else if(id == 3){
            prefab = new eui.Component();
            prefab.skinName = "mooncakeSkin";
            if(lane == 1){
                prefab.x = 37;
            }else if(lane == 2){
                prefab.x = 253;
            }else if(lane == 3){
                prefab.x = 469;
            }
            prefab.y = 0;
        }
        prefab.type = id;
        prefab.lane = lane;
        return prefab;
    }
    TargetMove(){
        if(this.prefabtarget){
            this.prefabtarget.y +=this.speed;
        }
        
    }
    gameOver(){
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.distance = Math.floor(this.distance /window['kilometer']);
        NetConst.ngameSubmit(
                    (s) => {
                        if (!s) {
                            ToastCtrl.instance.show("活动太火爆了，请稍后再来");
                            NetConst.ajaxElement((s) => {
                                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                            })
                            return
                        }else{
                            let data = { distance: this.distance, blocknum:this.collision,cakenum:this.getcake}
                            Waiting.instance.show();
                            PanelCtrl.instance.show(ModuleTypes.END_PANEL, data);
                        }
                    },
                    DataManager.ins.getData("doJoin").data,
                    this.getcake,
                    [],
                    [],
                    DataManager.ins.getData("getNgameStartStatus").data.submitToken,
                    window['rankId']
                )
    }

    removeEvents(){
        super.removeEvents();
        this.clearTap(this.goleft,this.onTap_goleft);
        this.clearTap(this.goright,this.onTap_goright);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }
    

}