import Scene from "../views/Scene";
import SceneCtrl from "../ctrls/sceneCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import ToastCtrl from "../ctrls/toastCtrl";
import { iqiyi } from "../NetConst";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import GameConst from "../GameConst";
import Waiting from "../waiting/Waiting";
import PanelCtrl from "../ctrls/panelCtrl";

export default class MyCardScene extends Scene{
    get skinKey(){return 'MyCard'}

    public cardList:eui.Scroller;
    public cardGroup:eui.Group;
    public cardItem:eui.Component;
    public cardBtn:eui.Button;
    public littleBtn:eui.Button;
    public littleBtn2:eui.Button;
    public backBtn:eui.Button;

    public text1:eui.Label;
    public text2:eui.Label;
    public text3:eui.Label;
    public line:eui.Image;

    private lastcard:number = 0;
    private nowcard:number = 0;
    private card:any;
    private cardid:any;

  

    private cardPool:any[] = [];
    private sceneBtnExposure:any;
    private duihuanBtnExposure:any;
    private duobaoBtnExposure:any;
    
    private postBtnExposure:any;
    private getBtnExposure:any
    private card1BtnExposure:any;
    private card2BtnExposure:any;
    private card3BtnExposure:any;
    private card4BtnExposure:any;
    private card5BtnExposure:any;
    private card6BtnExposure:any;
    private card7BtnExposure:any;
    private card8BtnExposure:any;
    private card9BtnExposure:any;
    private card10BtnExposure:any;
    private card11BtnExposure:any;
    private card0BtnExposure:any;
    constructor(data){
        super();
        this.initUI(data);
        this.card = data.carddata;
        this.cardItem.addEventListener(egret.TouchEvent.TOUCH_BEGIN,this.onTap_Begin,this)
        this.initBuired();
    }
    initBuired() {
        let sceneDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let sceneDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.sceneBtnExposure = Buried.createExposure(sceneDpmOut, sceneDcmOut);

        NetManager.ins.showLog(this.sceneBtnExposure);

        // let duihuanDpmOut = Buried.connectDpm(110, 33, 1); // 点击埋点   
        // let duihuanDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // this.duihuanBtnExposure = Buried.createExposure(duihuanDpmOut, duihuanDcmOut);

        // NetManager.ins.showLog(this.duihuanBtnExposure);
        

        // let duobaoDpmOut = Buried.connectDpm(110, 32, 1); // 点击埋点   
        // let duobaoDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // this.duobaoBtnExposure = Buried.createExposure(duobaoDpmOut, duobaoDcmOut);

        // NetManager.ins.showLog(this.duobaoBtnExposure);
    }

    initUI(data){
        // for()
        
        this.text2.text = data.numdata+"人";
        this.text2.x = this.text1.x+this.text1.width;
        this.text3.x = this.text2.x+this.text2.width;
        this.line.x = this.text2.x;
        this.line.width = this.text2.width;
        // this.nownum = data.numdata;
        for(let i = 0;i<data.carddata.length;i++){
            let cardDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
            let cardDcmOut = Buried.connectDcm(202, data.carddata[i].id, 0); // 曝光埋点
            this["card"+i+"BtnExposure"] = Buried.createExposure(cardDpmOut, cardDcmOut);

            NetManager.ins.showLog(this["card"+i+"BtnExposure"]);
            
            let com = new eui.Component();
            com.x = i*142;
            com.y = 0;
            com.skinName = "LittleCardItemSkin";
            com['cardbg'].visible = false;
            if(data.carddata[i].num == 0 || data.carddata[i].num == 1){
                com['numbg'].visible = false;
                com['cardnum'].visible = false;
                com['cardimg'].source = data.carddata[i].image;
            }else {
                com['cardimg'].source = data.carddata[i].image;
                com['cardnum'].text = data.carddata[i].num;
            }
            if(data.carddata[i].num == 0 ){
                this.setColor(com);
            }
            this.onTap(com,this.onTap_choseCard.bind(this,i,data.carddata[i].id));
            if(data.carddata[i].type == 0){
                if(data.carddata[i].num == 0){
                    this.setColor(com);
                }
            }
            this.cardPool.push(com);
            this.cardGroup.addChild(com);
            this.cardPool[0]['cardbg'].visible = true;
        }
        for(let i = 0;i<data.carddata.length;i++){
            // if(data.carddata[i].type == 0){
            //     if(data.carddata[i].num==0){
            //         this.setColor(this.cardItem["card"+i]);
            //     }
            // }
            this.cardItem["card"+i].source = data.carddata[i].image;
        }
        // if(data.carddata[0].num>0){
        //     this.cardBtn.icon = "givebtn_png"
        // }else{
        //     this.cardBtn.icon = "askbtn_png"
        // }
        this.cardBtn.visible = false;
        this.littleBtn.visible = false;
        this.littleBtn2.visible = false;
        let now = new Date();
        //2019/12/07 22:00:00  1575648000000
        
        if(now.getTime()>window['hongbaokaijiang']){
            this.cardBtn.touchChildren = false;
            this.littleBtn.touchChildren = false;
            this.littleBtn2.touchChildren = false;
            this.cardBtn.touchEnabled = false;
            this.littleBtn.touchEnabled = false;
            this.littleBtn2.touchEnabled = false;
            this.setColor(this.cardBtn);
            this.setColor(this.littleBtn);
            this.setColor(this.littleBtn2);
        }
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    onTap_choseCard(num,id){
        this.removeEvents()
        console.log(num);
        NetManager.ins.clickLog(this["card"+num+"BtnExposure"]);
        this.nowcard = num;
        this.cardid =id;
        if(this.lastcard!=this.nowcard){
            this.cardBtn.visible = false;
            this.littleBtn.visible = false;
            this.littleBtn2.visible = false;
            this.cardItem['cardbg'].visible = false;
        }
        
        
        for(let n = 0;n<this.cardPool.length;n++){
            this.cardPool[n]['cardbg'].visible = false;
        }
        this.cardPool[num]['cardbg'].visible = true;
        for(let m = 0; m<this.card.length;m++){
            egret.Tween.get(this.cardItem['card'+m])
            .to({x:this.cardItem['card'+m].x-(this.nowcard-this.lastcard)*408.5},Math.abs(this.nowcard-this.lastcard)*100);
        }
        if(this.lastcard!=this.nowcard){
            egret.Tween.get(this.cardItem['card'+this.lastcard])
            .to({scaleX:0.88,scaleY:0.88},100);
        }
        
        egret.Tween.get(this.cardItem['card'+this.nowcard])
        .wait(Math.abs(Math.abs(this.nowcard-this.lastcard)-1)*100)
        .to({scaleX:1,scaleY:1},100)
        .call(()=>{
            this.cardItem['cardbg'].visible = true;
            if(this.card[num].type == 0){
                this.cardBtn.visible = false;
                this.littleBtn.visible = false;
                this.littleBtn2.visible = false;
            }else if(this.card[num].type == 1 ||this.card[num].type == 3){
                if(this.card[num].num>0){
                    
                    if(this.card[num].type == 1){
                        this.littleBtn2.icon = "exbtn_png";
                        this.clearTap(this.littleBtn2,this.onTap_duobao)
                        this.clearTap(this.littleBtn2,this.onTap_wanneng)
                        this.onTap(this.littleBtn2,this.onTap_wanneng)
                    }else{
                        this.littleBtn2.icon = "getbtn_png";
                        this.clearTap(this.littleBtn2,this.onTap_duobao)
                        this.clearTap(this.littleBtn2,this.onTap_wanneng)
                        this.onTap(this.littleBtn2,this.onTap_duobao)
                    }
                    this.littleBtn.visible = true;
                    this.littleBtn2.visible = true;
                    this.littleBtn.icon = "givelittle_png"
                    this.onTap(this.littleBtn,this.onTap_giveCard)
                    this.cardBtn.visible = false;
                    let postDpmOut = Buried.connectDpm(110, 20, 1); // 点击埋点   
                    let postDcmOut = Buried.connectDcm(202, this.cardid, 0); // 曝光埋点
                    this.postBtnExposure = Buried.createExposure(postDpmOut, postDcmOut);

                    NetManager.ins.showLog(this.postBtnExposure);
                    
                    
                    
                }else{
                    this.cardBtn.icon = "askbtn_png"
                    this.cardBtn.visible = true;
                    this.littleBtn.visible = false;
                    this.littleBtn2.visible = false;
                    
                    this.clearTap(this.cardBtn,this.onTap_giveCard)
                    this.clearTap(this.cardBtn,this.onTap_askCard)
                    this.onTap(this.cardBtn,this.onTap_askCard)
                    let getDpmOut = Buried.connectDpm(110, 31, 1); // 点击埋点   
                    let getDcmOut = Buried.connectDcm(202, this.cardid, 0); // 曝光埋点
                    this.getBtnExposure = Buried.createExposure(getDpmOut, getDcmOut);

                    NetManager.ins.showLog(this.getBtnExposure);
                }
            }else if(this.card[num].type == 2){
                
                if(this.card[num].num>0){
                    this.cardBtn.icon = "givebtn_png"
                    this.clearTap(this.cardBtn,this.onTap_giveCard)
                    this.clearTap(this.cardBtn,this.onTap_askCard)
                    this.onTap(this.cardBtn,this.onTap_giveCard)
                    let postDpmOut = Buried.connectDpm(110, 20, 1); // 点击埋点   
                    let postDcmOut = Buried.connectDcm(202, this.cardid, 0); // 曝光埋点
                    this.postBtnExposure = Buried.createExposure(postDpmOut, postDcmOut);

                    NetManager.ins.showLog(this.postBtnExposure);
                }else{
                    this.cardBtn.icon = "askbtn_png"
                    this.clearTap(this.cardBtn,this.onTap_giveCard)
                    this.clearTap(this.cardBtn,this.onTap_askCard)
                    this.onTap(this.cardBtn,this.onTap_askCard)
                    let getDpmOut = Buried.connectDpm(110, 31, 1); // 点击埋点   
                    let getDcmOut = Buried.connectDcm(202, this.cardid, 0); // 曝光埋点
                    this.getBtnExposure = Buried.createExposure(getDpmOut, getDcmOut);

                    NetManager.ins.showLog(this.getBtnExposure);
                    
                }
                this.cardBtn.visible = true;
                this.littleBtn.visible = false;
                this.littleBtn2.visible = false;
            }
            this.getEvents();
        });
        this.lastcard = this.nowcard;
        
    }
    initEvents(){
        super.initEvents;
        this.onTap(this.backBtn,this.onTap_backBtn);
        this.onTap(this.littleBtn,this.onTap_giveCard);
        
    }

    getEvents(){
        for(let i = 0;i<this.cardPool.length;i++){
            this.cardPool[i].touchEnabled = true;
            this.cardPool[i].touchChildren = true
        }
    }
    removeEvents(){
        for(let i = 0;i<this.cardPool.length;i++){
            this.cardPool[i].touchEnabled = false;
            this.cardPool[i].touchChildren = false;
        }
    }
    onTap_backBtn(){
        Waiting.instance.show()
        iqiyi.getAllCards((ss)=>{
            if(!ss){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let carddata = DataManager.ins.getData("getAllCards").data;
            iqiyi.getCompletedNum((sss)=>{
                if(!sss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getCompletedNum").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let numdata = DataManager.ins.getData("getCompletedNum").data;
                iqiyi.getTasks((ssss)=>{
                    if(!ssss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getTasks").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let taskdata = DataManager.ins.getData("getTasks").data;
                    iqiyi.getCollectNum((res)=>{
                        Waiting.instance.hide()
                        if (!ssss) {
                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let collectdata = DataManager.ins.getData("getCollectNum").data;
                        let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: false }
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                    }, window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId)
    }
    
    onTap_askCard(){
        NetManager.ins.clickLog(this.getBtnExposure)
        Waiting.instance.show()
        console.log("索卡")
        // iqiyiShare(type,shareCode,cardId,token)
        //type =1 助力，type = 2赠卡，type=3 索卡，type =4日常分享
        
        iqiyi.getShareCode((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getShareCode").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getShareCode").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            let sharedata = DataManager.ins.getData('getShareCode').data;
            let cardid = this.cardid;
            //调用js拼连接
            window['iqiyiShare'](3,DataManager.ins.getData("getShareCode").data,cardid,null,4);
        },window["CFG"].activityId,2)
    }
    onTap_giveCard(){
        NetManager.ins.clickLog(this.postBtnExposure)
        Waiting.instance.show()
        console.log("赠卡")
        iqiyi.getShareCode((s)=>{
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getShareCode").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getShareCode").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            let sharedata = DataManager.ins.getData('getShareCode').data;
            iqiyi.getToken((s)=>{
                Waiting.instance.hide()
                if(!s){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getToken").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getToken").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return
                }
                let token = DataManager.ins.getData('getToken').data;
                let cardid = this.cardid;
                //调用js拼连接
                window['iqiyiShare'](2,DataManager.ins.getData("getShareCode").data,cardid,token,3);
            },window["CFG"].activityId)
        },window["CFG"].activityId,1)
    }
    onTap_wanneng(){
        //跳转万能卡兑换页面
        // NetManager.ins.clickLog(this.duihuanBtnExposure)
        Waiting.instance.show()
        iqiyi.getAllCards((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            let data = DataManager.ins.getData('getAllCards').data;
            SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE,data);
        },window["CFG"].activityId);
    }
    onTap_duobao(){
        // NetManager.ins.clickLog(this.duobaoBtnExposure)
        Waiting.instance.show()
        window.location.href = window['duobao']
        Waiting.instance.hide()
    }

    MoveCard(){
        this.cardItem.addEventListener(egret.TouchEvent.TOUCH_BEGIN,this.onTap_Begin,this);
    }
    startX;
    startY;
    onTap_Begin(e){
        egret.Tween.removeAllTweens();
        this.startX = e.stageX;
        this.startY = e.stageY;
        this.cardItem['cardbg'].visible = false;
        
        this.cardItem.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.onTap_Move, this);
        this.cardItem.addEventListener(egret.TouchEvent.TOUCH_END, this.onTap_End, this)
        this.cardItem.addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onTap_End, this);
    }
    onTap_Move(e){
        let endX = e.stageX;
        let endY = e.stageY;
        
        let offsetX = this.startX - endX;
        // if(offsetX>20){
            this.cardBtn.visible = false;
            this.littleBtn.visible = false;
            this.littleBtn2.visible = false;
        // }
        if (this.cardItem['card0'].x <= 375.5 && this.cardItem['card11'].x >= 375.5) {
            for(let i = 0;i<=11;i++){
                this.cardItem['card'+i].x-=offsetX
            }
            
            this.startX = endX;

            this.updateScale();
        }

    }
    offset0
    offset1
    offset2
    offset3
    offset4
    offset5
    offset6
    offset7
    offset8
    offset9
    offset10
    offset11
    onTap_End(){
        this.offset0 = Math.abs(this.cardItem['card0'].x - 375.5);
        this.offset1 = Math.abs(this.cardItem['card1'].x - 375.5);
        this.offset2 = Math.abs(this.cardItem['card2'].x - 375.5);
        this.offset3 = Math.abs(this.cardItem['card3'].x - 375.5);
        this.offset4 = Math.abs(this.cardItem['card4'].x - 375.5);
        this.offset5 = Math.abs(this.cardItem['card5'].x - 375.5);
        this.offset6 = Math.abs(this.cardItem['card6'].x - 375.5);
        this.offset7 = Math.abs(this.cardItem['card7'].x - 375.5);
        this.offset8 = Math.abs(this.cardItem['card8'].x - 375.5);
        this.offset9 = Math.abs(this.cardItem['card9'].x - 375.5);
        this.offset10 = Math.abs(this.cardItem['card10'].x - 375.5);
        this.offset11 = Math.abs(this.cardItem['card11'].x - 375.5);
        let minOffset = Math.min(this.offset0, this.offset1, this.offset2,this.offset3, this.offset4, this.offset5,this.offset6, this.offset7, this.offset8,this.offset9, this.offset10, this.offset11);
        let cardnum;
        if(this.cardItem['card0'].x>375.5){
            this.cardItem['card0'].x = 375.5
            for(let i = 1;i<12;i++){
                this.cardItem['card'+i].x -= this.offset0
            }
            cardnum = 0;
        }else if(this.cardItem['card11'].x<375.5){
            this.cardItem['card11'].x = 375.5
            for(let i = 0;i<11;i++){
                this.cardItem['card'+i].x += this.offset11
            }
            cardnum = 11;
        }else{
            for(let n = 0;n<12;n++){
                if(minOffset == this["offset"+n]){
                    cardnum = n
                    if(this.cardItem['card'+n].x>=375.5){
                        for(let i = 0;i<12;i++){
                            this.cardItem['card'+i].x -= this["offset"+n]
                        }
                    }else{
                        for(let i = 0;i<12;i++){
                            this.cardItem['card'+i].x += this["offset"+n]
                        }
                    }
                }
            }
            
        }
        this.updateScale()
        this.lastcard = cardnum;
        if(cardnum<7){
            this.cardList.viewport.scrollH = cardnum*142;
        }else{
            this.cardList.viewport.scrollH = 7*142;
        }
        
        this.onTap_choseCard(cardnum,this.card[cardnum].id);

    }

    updateScale() {
        for (let i = 0; i <= 11; i++) {
            try {
                if (this.cardItem[`card${i}`].x < 375.5) {
                    if (this.cardItem[`card${i}`].x > 0) {
                        let offset = 375.5 - this.cardItem[`card${i}`].x;
                        let rate = offset / 375.5;
                        this.cardItem[`card${i}`].scaleX = 1 - 0.12 * rate;
                        this.cardItem[`card${i}`].scaleY = 1 - 0.12 * rate;
                    }
                } else {
                    let offset = this.cardItem[`card${i}`].x - 375.5;
                    let rate = offset / 375.5 < 1 ? offset / 375.5 : 1;
                    this.cardItem[`card${i}`].scaleX = 1 - 0.12 * rate;
                    this.cardItem[`card${i}`].scaleY = 1 - 0.12 * rate;
                }
            } catch{

            }

        }

    }
}