import Panel from "../views/Panel";
import Waiting from "../waiting/Waiting";

export default class HongBaoPanel extends Panel{
    get skinKey(){return 'HongBao'}

    public rmblab:eui.Label;
    public yuan:eui.Label;
    public gai1:eui.Image;
    public gai2:eui.Image;
    public gai3:eui.Image;
    public gai4:eui.Image;
    public gai5:eui.Image;
    public getRMB:eui.Button;
    public closeBtn:eui.Button;
    public link :any;
    constructor(data){
        super();
        this.initUI(data);
        // this.initAni()
    }

    initUI(data){
        //获取数据
        if(data){
            this.rmblab.text = data.amount;
            this.link = data.link;
        }
        this.gai1.visible = true;
        this.getRMB.icon = "hongBtn_png"
        this.onTap(this.getRMB,this.onTap_getHongbao);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
    }   
    initAni(){
        this.gai1.visible = true;
        this.gai2.visible = false;
        this.gai3.visible = false;
        this.gai4.visible = false;
        this.gai5.visible = false;
        setTimeout(()=>{
            this.gai1.visible = false;
            this.gai2.visible = true
        },200);
        setTimeout(()=>{
            this.gai2.visible = false;
            this.gai3.visible = true
        },400)
        setTimeout(()=>{
            this.gai3.visible = false;
            this.gai4.visible = true
        },600)
        setTimeout(()=>{
            this.gai4.visible = false;
            this.gai5.visible = true
        },800)
        setTimeout(()=>{
            this.gai5.visible = false;
        },1000)

        
    }

    onTap_closeBtn(){
        this.hidePanel()
    }

    onTap_getRMB(){
        Waiting.instance.show()
        window.location.href = this.link;
        Waiting.instance.hide()
    }
    onTap_getHongbao(){
        this.initAni()
        this.getRMB.icon = "hongbaoBtn_png"
        this.clearTap(this.getRMB,this.onTap_getHongbao);
        this.onTap(this.getRMB,this.onTap_getRMB);
    }

}