import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { iqiyi } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import GameConst from "../GameConst";
import SVGACtrl from "../ctrls/svgaCtrl";
import Waiting from "../waiting/Waiting";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class GetCardPanel extends Panel{
    get skinKey(){return 'GetCard'}
    public getCardGroup:eui.Group;
    public light:eui.Image;
    public cardname:eui.Label;
    public cardintr:eui.Label;
    public card:eui.Image;
    public carddesign:eui.Image;
    public getcard:eui.Button;
    public gettimes:eui.Label;
    public closeBtn:eui.Button;
    public cardurl:eui.Group;
    public urllab:eui.Label;

    private urlfunc:any;
    private cardfunc:any;
    private wuyongid:any;
    public cardbg:eui.Image;
    public insGroup:eui.Group;

    private _data:any;
    private datatype:any;

    public getFudaiGroup:eui.Group;
    public fuclose:eui.Button;
    public prizeimg:eui.Image;
    public prizename:eui.Label;
    public getfuBtn:eui.Button;

    public getDouGroup:eui.Group;
    public cardprize:eui.Image;
    public cardlab:eui.Label;
    public douprize:eui.Image;
    public dougetBtn:eui.Button;
    public douclose:eui.Button;


    private choukaBtnExposure:any
    private shoukaBtnExposure:any;
    private zengkaBtnExposure:any;
    private duobaoBtnExposure:any;
    private wannengBtnExposure:any;
        
    private lottery;
    constructor(data){
        super();
        this._data = data.data;
        this.datatype = data.datatype;
        this.wuyongid = data.wuyong;
        if(data.lottery){
            this.lottery = data.lottery;
            if(data.lottery.type == 'thanks'){
                this.getCardGroup.visible = true;
                this.getFudaiGroup.visible = false;
                this.getDouGroup.visible = false;
                this.initUI(this._data,this.datatype);
                this.initAni()
            }else{
                if(data.data.id){
                    //有福袋，有卡片
                    this.getCardGroup.visible = false;
                    this.getFudaiGroup.visible = false;
                    this.getDouGroup.visible = true;
                    this.initUIDou();
                }else{
                    //有福袋，没有卡片
                    this.getCardGroup.visible = false;
                    this.getFudaiGroup.visible = true;
                    this.getDouGroup.visible = false;
                    this.initUIFu();
                }
            }
        }else{
            this.getCardGroup.visible = true;
            this.getFudaiGroup.visible = false;
            this.getDouGroup.visible = false;
            this.initUI(this._data,this.datatype);
            this.initAni()
        }
    }
    initBuired() {
        
        
    }
    isfirst:boolean = true;
    isfirst2:boolean = true;
    cardsource:any
    initUI(data,datatype){
        
       // card 显示根据data ？？显示（未写）
       // gettimes 根据data ？？显示（未写）
        for(let i = 0;i<DataManager.ins.getData('getAllCards').data.length;i++){
            if(data.id == DataManager.ins.getData('getAllCards').data[i].id){
                this.card.source = DataManager.ins.getData('getAllCards').data[i].image;
                this.cardsource = DataManager.ins.getData('getAllCards').data[i].image;
            }
        }
        
        if(datatype == 1){
            
            if(this.isfirst){
                let choukaDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
                let choukaDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                this.choukaBtnExposure = Buried.createExposure(choukaDpmOut, choukaDcmOut);

                NetManager.ins.showLog(this.choukaBtnExposure);
                this.isfirst = false;
            }
            
            
            if(data.collectNum>0){
                this.gettimes.text = "继续集卡*"+data.collectNum;
                this.onTap(this.gettimes,this.onTap_getcard);
            }else{
                this.clearTap(this.gettimes,this.onTap_getcard)
                this.onTap(this.gettimes,this.onTap_backStartScene)
                this.gettimes.text = "增加集卡次数";
            }

            if(data.id){
                let carddata = DataManager.ins.getData('getAllCards').data;
                for(let i = 0;i<carddata.length;i++){
                    if(data.id == carddata[i].id){
                        //1 万能卡，2明星卡，3夺宝卡，0超级爱豆卡
                        if(carddata[i].type == 1){
                            this.light.y = 92+this.light.height/2;
                            this.cardname.y = 168;
                            this.cardintr.y = 226;
                            this.card.y = 296+this.card.height/2;
                            this.cardbg.y = this.card.y-263;
                            this.carddesign.y = 310;
                            this.getcard.y = 808+this.getcard.height/2;
                            this.gettimes.y = 808+this.gettimes.height/2;
                            this.closeBtn.y = 1054+this.closeBtn.height/2;
                            this.cardurl.visible = true;
                            this.cardname.text = "恭喜你获得一张万能卡"
                            this.cardintr.text = "可兑换任何一种你想要的卡"
                            this.urlfunc = this.onTap_cardurl.bind(this,"wanneng");
                            this.onTap(this.cardurl,this.urlfunc);
                            this.urllab.text = "去兑换"
                            if(this.isfirst2){
                                let wannengDpmOut = Buried.connectDpm(110, 33, 1); // 点击埋点   
                                let wannengDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                                this.wannengBtnExposure = Buried.createExposure(wannengDpmOut, wannengDcmOut);

                                NetManager.ins.showLog(this.wannengBtnExposure);
                                this.isfirst2 = false;
                            }
        
                        }else if(carddata[i].type == 2){
                            this.light.y = 152+this.light.height/2;
                            this.cardname.y = 228;
                            this.cardintr.y = 286;
                            this.cardintr.visible = false;
                            this.card.y = 356+this.card.height/2;
                            this.cardbg.y = this.card.y-263;
                            this.carddesign.y = 370;
                            this.getcard.y = 868+this.getcard.height/2;
                            this.gettimes.y = 868+this.gettimes.height/2;
                            this.closeBtn.y = 994+this.closeBtn.height/2;
                            this.cardurl.visible = false;
                        }else if(carddata[i].type == 3){
                            this.light.y = 92+this.light.height/2;
                            this.cardname.y = 168;
                            this.cardintr.y = 226;
                            this.card.y = 296+this.card.height/2;
                            this.cardbg.y = this.card.y-263;
                            this.carddesign.y = 310;
                            this.getcard.y = 808+this.getcard.height/2;
                            this.gettimes.y = 808+this.gettimes.height/2;
                            this.closeBtn.y = 1054+this.closeBtn.height/2;
                            this.cardurl.visible = true;
                            this.cardname.text = "恭喜你获得一张夺宝卡"
                            this.cardintr.text = "可开启夺宝模式"
                            this.urlfunc = this.onTap_cardurl.bind(this,"duobao");
                            this.onTap(this.cardurl,this.urlfunc);
                            this.urllab.text = "去夺宝"
                            if(this.isfirst2){
                                let duobaoDpmOut = Buried.connectDpm(110, 32, 1); // 点击埋点   
                                let duobaoDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                                this.duobaoBtnExposure = Buried.createExposure(duobaoDpmOut, duobaoDcmOut);

                                NetManager.ins.showLog(this.duobaoBtnExposure);
                                this.isfirst2  = false;
                            }
        
                        }
                    }
                }
            }else{
                this.light.y = 152+this.light.height/2;
                this.cardname.y = 228;
                this.cardname.text = "卡片溜走了"
                this.cardintr.y = 286;
                this.cardintr.visible = false;
                this.card.y = 356+this.card.height/2;
                this.cardbg.y = this.card.y-263;
                this.carddesign.y = 370;
                this.getcard.y = 868+this.getcard.height/2;
                this.gettimes.y = 868+this.gettimes.height/2;
                this.closeBtn.y = 994+this.closeBtn.height/2;
                this.cardurl.visible = false;
                
                this.card.source = "wuyong"+this.wuyongid+"_png"
                this.cardsource = "wuyong"+this.wuyongid+"_png"
            }
            
        }else if(datatype == 2){
            egret.Tween.removeAllTweens();
            if(this.isfirst){
                let shoukaDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
                let shoukaDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                this.shoukaBtnExposure = Buried.createExposure(shoukaDpmOut, shoukaDcmOut);

                NetManager.ins.showLog(this.shoukaBtnExposure);
                this.isfirst = false;
            }
            
            this.light.y = 152+this.light.height/2;
            this.cardname.y = 286;
            this.cardintr.visible = false;
            this.card.y = 356+this.card.height/2;
            this.cardbg.y = this.card.y-263;
            this.carddesign.y = 370;
            this.getcard.y = 868+this.getcard.height/2;
            this.gettimes.y = 868+this.gettimes.height/2;
            this.closeBtn.y = 994+this.closeBtn.height/2;
            this.cardurl.visible = false;
            for(let m = 0;m<DataManager.ins.getData('getAllCards').data.length;m++){
                if(data.id == DataManager.ins.getData('getAllCards').data[m].id){
                    if(DataManager.ins.getData('getAllCards').data[m].mark == "DB"){
                        this.cardname.text = "你的好友赠送你一张夺宝卡"
                    }else if(DataManager.ins.getData('getAllCards').data[m].mark == "WN"){
                        this.cardname.text = "你的好友赠送你一张万能卡"
                    }else{
                        this.cardname.text = "你的好友赠送你一张爱豆卡"
                    }
                }
            }
            
            this.gettimes.text = "收下"
            this.onTap(this.gettimes,this.onTap_get);
        }else if(datatype == 3){
            egret.Tween.removeAllTweens();
            if(this.isfirst){
                let zengkaDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
                let zengkaDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                this.zengkaBtnExposure = Buried.createExposure(zengkaDpmOut, zengkaDcmOut);

                NetManager.ins.showLog(this.zengkaBtnExposure);
                this.isfirst = false;
            }
            this.light.y = 152+this.light.height/2;
            this.cardname.y = 286;
            this.cardintr.visible = false;
            this.card.y = 356+this.card.height/2;
            this.cardbg.y = this.card.y-263;
            this.carddesign.y = 370;
            this.getcard.y = 868+this.getcard.height/2;
            this.gettimes.y = 868+this.gettimes.height/2;
            this.closeBtn.y = 994+this.closeBtn.height/2;
            this.cardurl.visible = false;
            for(let m = 0;m<DataManager.ins.getData('getAllCards').data.length;m++){
                if(data.id == DataManager.ins.getData('getAllCards').data[m].id){
                    if(DataManager.ins.getData('getAllCards').data[m].mark == "DB"){
                        this.cardname.text = "你的好友向你索要一张夺宝卡"
                    }else if(DataManager.ins.getData('getAllCards').data[m].mark == "WN"){
                        this.cardname.text = "你的好友向你索要一张万能卡"
                    }else{
                        this.cardname.text = "你的好友向你索要一张爱豆卡"
                    }
                }
            }
            this.gettimes.text = "赠送给TA"
            this.onTap(this.gettimes,this.onTap_give);
        }

        /*
        type = 1 抽到爱豆卡
        type = 2 抽到万能卡
        type = 3 抽到夺宝卡
        type = 4 收到好友索卡请求
        type = 5 收到好友赠卡
        */
        // if(data.type == 4 || data.type == 5){
        //     this.light.y = 152;
        //     this.cardname.y = 286;
        //     this.cardintr.visible = false;
        //     this.card.y = 356;
        //     this.carddesign.y = 370;
        //     this.getcard.y = 868;
        //     this.gettimes.y = 868;
        //     this.closeBtn.y = 994;
        //     this.cardurl.visible = false;
        //     if(data.type == 4){
        //         this.cardname.text = "xx向你索要一张爱豆卡"
        //         this.gettimes.text = "赠送给TA"
        //     }else if(data.type == 5){
        //         this.cardname.text = "xx赠送你一张爱豆卡"
        //         this.gettimes.text = "收下"
        //     }
        // }
    }
    initAni(){
            this.light.visible = false;
            this.cardname.visible = false;
            this.cardintr.visible = false;
            this.card.visible = true;
            this.cardbg.visible = false
            this.carddesign.visible = false;
            this.getcard.visible = false;
            this.gettimes.visible = false;
            this.closeBtn.visible = false;
            this.cardurl.visible = false;
            this.card.source = "cardbg_png"
            egret.Tween.get(this.card)
            .set({scaleX:3,scaleY:3,alpha:0.3})
            .to({scaleX:0.8,scaleY:0.8,alpha:0.66},500)
            .call(()=>{
                egret.Tween.get(this.card)
                .to({scaleX:1,scaleY:1,alpha:1},170)
                .wait(500)
                .call(()=>{
                    this.card.visible = false;
                    this.card.source = this.cardsource;
                    let SvgaData = SVGACtrl.instance.getSVGAByName("chouka");
                    let svga = new window['SVGA'].EgretMovieClip(SvgaData);
                    svga.anchorOffsetX = this.card.width/2
                    svga.anchorOffsetY =this.card.height/2
                    svga.x = this.card.x-51;
                    svga.y = this.card.y-286;
                    this.addChild(svga);
                    setTimeout(async()=>{
                        
                        
                        egret.Tween.get(this.insGroup)
                        .set({alpha:0})
                        .to({alpha:1},300)
                        this.light.visible = true;
                        this.cardname.visible = true;
                        this.cardintr.visible = true;
                        this.card.visible = true;
                        this.cardbg.visible = true
                        this.carddesign.visible = false;
                        this.getcard.visible = true;
                        this.gettimes.visible = true;
                        this.closeBtn.visible = true;
                        this.cardurl.visible = true;
                        await this.initUI(this._data,this.datatype)

                        this.removeChild(svga);
                        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)
                    },680)
                })
            })
            
    }
    onEnterFrame(){
        this.light.rotation+= 1
    }

    initEvents(){{
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn)
        GameConst.BtnAni(this.getcard,this.gettimes);
    }}

    onTap_cardurl(data){
        Waiting.instance.show()
        if(data == "wanneng"){
            //跳转万能卡兑换页面
            NetManager.ins.clickLog(this.wannengBtnExposure)
            iqiyi.getAllCards((s)=>{
                Waiting.instance.hide()
                if(!s){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getAllCards").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return
                }
                let data = DataManager.ins.getData('getAllCards').data;
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE,data);
                this.hidePanel()
            },window["CFG"].activityId);
            
        }else if(data == "duobao"){
            NetManager.ins.clickLog(this.duobaoBtnExposure)
            window.location.href = window['duobao']
        }
    }

    onTap_closeBtn(){
        //调接口 刷新首页
        history.pushState("", document.title, "//activity.m.duiba.com.cn/customActivity/iqiyi/scream/index?activityId=3737913&dbnewopen");
        Waiting.instance.show()
        iqiyi.getAllCards((ss)=>{
            if(!ss){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let carddata = DataManager.ins.getData("getAllCards").data;
            iqiyi.getCompletedNum((sss)=>{
                if(!sss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getCompletedNum").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let numdata = DataManager.ins.getData("getCompletedNum").data;
                iqiyi.getTasks((ssss)=>{
                    if(!ssss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getTasks").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let taskdata = DataManager.ins.getData("getTasks").data;
                    iqiyi.getCollectNum((res)=>{
                        Waiting.instance.hide()
                        if (!ssss) {

                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let collectdata = DataManager.ins.getData("getCollectNum").data;
                        let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: false }
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                        this.hidePanel()
                    }, window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId)
    }

    onTap_getcard(){
        NetManager.ins.clickLog(this.choukaBtnExposure)
        this.isfirst = true;
        this.isfirst2 = true;
        Waiting.instance.show()
        iqiyi.collect((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("collect").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("collect").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let data = DataManager.ins.getData('collect').data;
            let carddata = {};
            if(data.id){
                for(let i = 0; i<DataManager.ins.getData('getAllCards').data.length;i++){
                    if(data.id == DataManager.ins.getData('getAllCards').data[i].id){
                        SVGACtrl.instance.load("chouka",DataManager.ins.getData('getAllCards').data[i].mark+".svga");
                        carddata = {data:data,wuyong:99,datatype:1};
                    }
                }
                
            }else{
                let num = Math.floor(Math.random()*6+1);
                SVGACtrl.instance.load("chouka","wuyong"+num+".svga");
                carddata = {data:data,wuyong:num,datatype:1};
            }
            PanelCtrl.instance.show2(ModuleTypes.GETCARD_PANEL,carddata);
        },window["CFG"].activityId)
    }
    onTap_backStartScene(){
        //调接口 刷新首页
        Waiting.instance.show()
        iqiyi.getAllCards((ss)=>{
            if(!ss){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let carddata = DataManager.ins.getData("getAllCards").data;
            iqiyi.getCompletedNum((sss)=>{
                if(!sss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getCompletedNum").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let numdata = DataManager.ins.getData("getCompletedNum").data;
                iqiyi.getTasks((ssss)=>{
                    if(!ssss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getTasks").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let taskdata = DataManager.ins.getData("getTasks").data;
                    iqiyi.getCollectNum((res)=>{
                        Waiting.instance.hide()
                        if (!ssss) {
                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let collectdata = DataManager.ins.getData("getCollectNum").data;
                        let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: true }
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                        this.hidePanel()
                    }, window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId)
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.cardurl,this.urlfunc);
    }
    onTap_give(){
        Waiting.instance.show()
        iqiyi.give((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("give").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("give").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            var state = {
                title: document.title,
                url: document.location.href,
                otherkey: null
            };
            history.pushState(state, document.title, "//activity.m.duiba.com.cn/customActivity/iqiyi/scream/index?activityId=3737913&dbnewopen");
            this.onTap_closeBtn();
        },window["CFG"].activityId,GameConst.getQueryString("shareCode"),GameConst.getQueryString("cardId"))
    }
    onTap_get(){
        Waiting.instance.show()
        iqiyi.receive((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("receive").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("receive").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return
            }
            var state = {
                title: document.title,
                url: document.location.href,
                otherkey: null
            };
            history.pushState(state, document.title, "//activity.m.duiba.com.cn/customActivity/iqiyi/scream/index?activityId=3737913&dbnewopen");
            this.onTap_closeBtn();
        },window["CFG"].activityId,GameConst.getQueryString("shareCode"),GameConst.getQueryString("cardId"),GameConst.getQueryString("token"))
    }

    initUIFu(){
        this.onTap(this.fuclose,this.onTap_closeBtn);
        this.prizeimg.source = this.lottery.imgUrl;
        this.prizename.text = this.lottery.title;
        this.onTap(this.getfuBtn,this.onTap_goUrl);
        this.BtnAni(this.getfuBtn);
    }
    initUIDou(){
        this.BtnAni(this.dougetBtn);
        for(let i = 0;i<DataManager.ins.getData('getAllCards').data.length;i++){
            if(this._data.id == DataManager.ins.getData('getAllCards').data[i].id){
                this.cardprize.source = DataManager.ins.getData('getAllCards').data[i].image;
                if(DataManager.ins.getData('getAllCards').data[i].type == 1){
                    //万能卡
                    this.cardlab.text = "一张万能卡"
                }else if(DataManager.ins.getData('getAllCards').data[i].type == 2){
                    //明星卡
                    this.cardlab.text = "一张爱豆卡"
                }else if(DataManager.ins.getData('getAllCards').data[i].type == 3){
                    //夺宝卡
                    this.cardlab.text = "一张夺宝卡"
                }
            }
        }
        this.onTap(this.douclose,this.onTap_closeBtn);
        this.douprize.source = this.lottery.imgUrl;
        this.onTap(this.dougetBtn,this.onTap_goUrl);
    }

    onTap_goUrl(){
        window.location.href = this.lottery.link;
        this.onTap_closeBtn();
    }
    BtnAni(button){
        egret.Tween.get(button)
        .set({scaleX:1,scaleY:1})
        .to({scaleX:0.8,scaleY:0.8},500)
        .call(()=>{
            egret.Tween.get(button)
            .to({scaleX:1,scaleY:1},500)
            .call(()=>{
                this.BtnAni(button)
            })
        })
    }
}