import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import ToastCtrl from "../ctrls/toastCtrl";
import { iqiyi } from "../NetConst";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import GameConst from "../GameConst";
import Waiting from "../waiting/Waiting";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class ExchangeScene extends Scene{
    get skinKey(){return 'Exchange'}

    public card1Group:eui.Group;
    public card1:eui.Image;
    public gou1:eui.Image;
    public card2Group:eui.Group;
    public card2:eui.Image;
    public gou2:eui.Image;
    public card3Group:eui.Group;
    public card3:eui.Image;
    public gou3:eui.Image;
    public card4Group:eui.Group;
    public card4:eui.Image;
    public gou4:eui.Image;
    public card5Group:eui.Group;
    public card5:eui.Image;
    public gou5:eui.Image;
    public card6Group:eui.Group;
    public card6:eui.Image;
    public gou6:eui.Image;
    public card7Group:eui.Group;
    public card7:eui.Image;
    public gou7:eui.Image;
    public card8Group:eui.Group;
    public card8:eui.Image;
    public gou8:eui.Image;
    public card9Group:eui.Group;
    public card9:eui.Image;
    public gou9:eui.Image;

    public choseBtn:eui.Button;
    public backBtn:eui.Button;
    public choselab:eui.Label;
    public choseBtn0:eui.Button;
    public choselab0:eui.Label;

    private card1id:any;
    private card2id:any;
    private card3id:any;
    private card4id:any;
    private card5id:any;
    private card6id:any;
    private card7id:any;
    private card8id:any;
    private card9id:any;

    private getid:any = 0;


    private exchangeBtnExposure:any;
    constructor(data){
        super();
        this.initUI(data);
        this.initBuried()
    }
    //调用获取所有卡片接口对应data
    initUI(data){
        let n = 1;
        for(let i = 0;i<data.length;i++){
            if(data[i].type == 2){
                //对应图片（后期修改）
                this["card"+n].source = data[i].image;
                this["gou"+n].source = "notgetcard_png"
                this["card"+n+"id"] = data[i].id;
                n++;
            }
        }
        this.setColor(this.choseBtn0)
        this.setColor(this.choselab0);
        this.choselab.touchEnabled = false;
        this.choseBtn.touchChildren = false;
        this.choseBtn.touchEnabled = false;


    }
    initBuried(){
        let exchangeDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let exchangeDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.exchangeBtnExposure = Buried.createExposure(exchangeDpmOut, exchangeDcmOut);

        NetManager.ins.showLog(this.exchangeBtnExposure);
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.card1Group,this.onTap_cardchose.bind(this,1));
        this.onTap(this.card2Group,this.onTap_cardchose.bind(this,2));
        this.onTap(this.card3Group,this.onTap_cardchose.bind(this,3));
        this.onTap(this.card4Group,this.onTap_cardchose.bind(this,4));
        this.onTap(this.card5Group,this.onTap_cardchose.bind(this,5));
        this.onTap(this.card6Group,this.onTap_cardchose.bind(this,6));
        this.onTap(this.card7Group,this.onTap_cardchose.bind(this,7));
        this.onTap(this.card8Group,this.onTap_cardchose.bind(this,8));
        this.onTap(this.card9Group,this.onTap_cardchose.bind(this,9));
        this.onTap(this.choselab,this.onTap_getCard);
        this.onTap(this.backBtn,this.onTap_backBtn);
        GameConst.BtnAni(this.choseBtn,this.choselab);
    }

    onTap_cardchose(id){
        
        for(let i = 1; i<=9;i++){
            this["gou"+i].source = "notgetcard_png";
        }
        this["gou"+id].source = "getcard_png";
        this.getid = this["card"+id+"id"];
        this.choseBtn0.visible = false;
        this.choselab0.visible = false;
        this.choselab.touchEnabled = true;
        this.choseBtn.touchChildren = true;
        this.choseBtn.touchEnabled = true;
    }

    onTap_getCard(){
        if(this.getid == 0){
            ToastCtrl.instance.show("请选择卡片");
        }else{
            PanelCtrl.instance.show(ModuleTypes.EXCHANGECARD_PANEL,this.getid);
        }
        
    }
    onTap_backBtn(){
        Waiting.instance.show()
        iqiyi.getAllCards((ss)=>{
            if(!ss){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let carddata = DataManager.ins.getData("getAllCards").data;
            iqiyi.getCompletedNum((sss)=>{
                if(!sss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getCompletedNum").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let numdata = DataManager.ins.getData("getCompletedNum").data;
                iqiyi.getTasks((ssss)=>{
                    if(!ssss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getTasks").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let taskdata = DataManager.ins.getData("getTasks").data;
                    iqiyi.getCollectNum((res)=>{
                        Waiting.instance.hide()
                        if (!ssss) {
                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let collectdata = DataManager.ins.getData("getCollectNum").data;
                        let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: false }
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                    }, window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId)
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    
}