import Panel from "../views/Panel";
import { iqiyi } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class ExchangeCardPanel extends Panel{
    get skinKey(){return 'ExchangeCard'}
    public thinkBtn:eui.Button;
    public exchangeBtn:eui.Button;
    public closeBtn:eui.Button;

    private id :any

    private thinkBtnBtnExposure:any;
    private exchangeBtnBtnExposure:any;
    constructor(data){
        super();
        this.id = data;
        this.initBuried();
    }
    initEvents(){
        super.initEvents();
        this.onTap(this.thinkBtn,this.onTap_thinkBtn);
        this.onTap(this.exchangeBtn,this.onTap_exchangeBtn);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
    }
    
    onTap_closeBtn(){
        this.hidePanel();
    }
    onTap_thinkBtn(){
        NetManager.ins.clickLog(this.thinkBtnBtnExposure)
        this.hidePanel();
    }

    initBuried(){
        let thinkBtnDpmOut = Buried.connectDpm(110, 29, 1); // 点击埋点   
        let thinkBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.thinkBtnBtnExposure = Buried.createExposure(thinkBtnDpmOut, thinkBtnDcmOut);

        NetManager.ins.showLog(this.thinkBtnBtnExposure);

        let exchangeBtnDpmOut = Buried.connectDpm(110, 30, 1); // 点击埋点   
        let exchangeBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.exchangeBtnBtnExposure = Buried.createExposure(exchangeBtnDpmOut, exchangeBtnDcmOut);

        NetManager.ins.showLog(this.exchangeBtnBtnExposure);
        
    }

    onTap_exchangeBtn(){
        NetManager.ins.clickLog(this.exchangeBtnBtnExposure)
        Waiting.instance.show()
        iqiyi.exchange((s)=>{
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("exchange").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("exchange").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            iqiyi.getAllCards((ss)=>{
                if(!ss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getAllCards").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let carddata = DataManager.ins.getData("getAllCards").data;
                iqiyi.getCompletedNum((sss)=>{
                    if(!sss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getCompletedNum").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let numdata = DataManager.ins.getData("getCompletedNum").data;
                    iqiyi.getTasks((ssss)=>{
                        if(!ssss){
                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getTasks").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let taskdata = DataManager.ins.getData("getTasks").data;
                        iqiyi.getCollectNum((res)=>{
                            Waiting.instance.hide()
                            if (!ssss) {
                                // ToastCtrl.instance.show("网络异常，请重试");
                                if(DataManager.ins.getData("getCollectNum").desc){
                                    ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                                }else{
                                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                                }
                                return;
                            }
                            let collectdata = DataManager.ins.getData("getCollectNum").data;
                            let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: false }
                            SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                            this.hidePanel();
                        }, window["CFG"].activityId)
                    },window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId,this.id);
    }

}