import Panel from "../views/Panel";
import { iqiyi } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Waiting from "../waiting/Waiting";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import SVGACtrl from "../ctrls/svgaCtrl";
import GameConst from "../GameConst";

export default class ComposePanel extends Panel{
    get skinKey(){ return 'Compose'}

    public composeGroup:eui.Group;
    public composeBtn:eui.Button;
    public finishGroup:eui.Group;
    public closeBtn:eui.Button;

    public light:eui.Image;
    public btnlight:eui.Image;

    public card11:eui.Image;
    public card1:eui.Image;
    public card12:eui.Image;
    public card2:eui.Image;
    public card13:eui.Image;
    public card3:eui.Image;
    public card14:eui.Image;
    public card4:eui.Image;
    public card15:eui.Image;
    public card5:eui.Image;
    public card16:eui.Image;
    public card6:eui.Image;
    public card17:eui.Image;
    public card7:eui.Image;
    public card18:eui.Image;
    public card8:eui.Image;
    public card19:eui.Image;
    public card9:eui.Image;
    public comcard:eui.Image;

    private carddata:any;

    public cardGroup:eui.Group;

    private chaojiBtnExposure:any;
    private hechengBtnExposure:any;
    constructor(data){
        super();
        this.carddata = data;
        this.composeGroup.visible =true;
        this.finishGroup.visible = false;
        this.composeBtn.touchChildren = false;
        this.composeBtn.touchEnabled = false;
        this.initUI(data);
        this.initAni()
        this.initBuried();
        GameConst.BtnAni(this.btnlight,this.composeBtn)
        

    }
    initUI(data){
        let arr:any[] = []
        for(let i = 0;i<data.length;i++){
            if(data[i].type == 2){
                arr.push(data[i]);
            }
        }
        for(let n = 0; n<arr.length;n++){
            let m = n+1
            this["card"+m].source = arr[n].image;
            
        }
        
    }
    initAni(){
        egret.Tween.get(this.composeBtn).wait(1430).set({scaleX:0,scaleY:0}).to({scaleX:1.1,scaleY:1.1},670)
        .call(()=>{egret.Tween.get(this.composeBtn).to({scaleX:1,scaleY:1},200)})
        egret.Tween.get(this.btnlight).wait(1430).set({scaleX:0,scaleY:0}).to({scaleX:1.1,scaleY:1.1},670)
        .call(()=>{egret.Tween.get(this.btnlight).to({scaleX:1,scaleY:1},200)})
        egret.Tween.get(this.card1).wait(1430).to({x:this.card1.x+134,y:this.card1.y-182},500);
        egret.Tween.get(this.card11).wait(1430).to({x:this.card11.x+134,y:this.card11.y-182},500);

        egret.Tween.get(this.card2).wait(1500).to({x:this.card2.x+142,y:this.card2.y-182},500)
        egret.Tween.get(this.card12).wait(1500).to({x:this.card12.x+142,y:this.card12.y-182},500)

        egret.Tween.get(this.card3).wait(1570).to({x:this.card3.x+150,y:this.card3.y-182},500)
        egret.Tween.get(this.card13).wait(1570).to({x:this.card13.x+150,y:this.card13.y-182},500)

        egret.Tween.get(this.card4).wait(1630).to({x:this.card4.x-293,y:this.card4.y+24},500)
        egret.Tween.get(this.card14).wait(1630).to({x:this.card14.x-293,y:this.card14.y+24},500)

        egret.Tween.get(this.card5).wait(1700).to({x:this.card5.x-285,y:this.card5.y+24},500)
        egret.Tween.get(this.card15).wait(1700).to({x:this.card15.x-285,y:this.card15.y+24},500)

        egret.Tween.get(this.card6).wait(1770).to({x:this.card6.x+364,y:this.card6.y-192},500)
        egret.Tween.get(this.card16).wait(1770).to({x:this.card16.x+364,y:this.card16.y-192},500)

        egret.Tween.get(this.card7).wait(1830).to({x:this.card7.x-78,y:this.card7.y+12},500)
        egret.Tween.get(this.card17).wait(1830).to({x:this.card17.x-78,y:this.card17.y+12},500)

        egret.Tween.get(this.card8).wait(1900).to({x:this.card8.x-70,y:this.card8.y+12},500)
        egret.Tween.get(this.card18).wait(1900).to({x:this.card18.x-70,y:this.card18.y+12},500)

        egret.Tween.get(this.card9).wait(1970).to({x:this.card9.x-62,y:this.card9.y+12},500)
        egret.Tween.get(this.card19).wait(1970).to({x:this.card19.x-62,y:this.card19.y+12},500).call(()=>{
            this.composeBtn.touchChildren = true;
            this.composeBtn.touchEnabled = true;
        })
        // this.loadSVGA()
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.composeBtn,this.onTap_composeBtn);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)
    }
    onEnterFrame(){
        this.btnlight.rotation+= 1
    }
    initBuried(){
        let hechengDpmOut = Buried.connectDpm(110, 28, 1); // 点击埋点   
        let hechengDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.hechengBtnExposure = Buried.createExposure(hechengDpmOut, hechengDcmOut);

        NetManager.ins.showLog(this.hechengBtnExposure);
        
    }


    onTap_composeBtn(){
        Waiting.instance.show()
        NetManager.ins.clickLog(this.hechengBtnExposure)
        iqiyi.merge((s)=>{
            Waiting.instance.hide()
            if(!s){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("merge").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("merge").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                
                return;
            }
            //动效
            this.composeAni();
            
            
            
        },window["CFG"].activityId)
    }
    initAnicom(){
        egret.Tween.get(this.card1).wait(430).to({x:this.card1.x+134,y:this.card1.y-182},500);
        egret.Tween.get(this.card11).wait(430).to({x:this.card11.x+134,y:this.card11.y-182},500);

        egret.Tween.get(this.card2).wait(500).to({x:this.card2.x+142,y:this.card2.y-182},500)
        egret.Tween.get(this.card12).wait(500).to({x:this.card12.x+142,y:this.card12.y-182},500)

        egret.Tween.get(this.card3).wait(570).to({x:this.card3.x+150,y:this.card3.y-182},500)
        egret.Tween.get(this.card13).wait(570).to({x:this.card13.x+150,y:this.card13.y-182},500)

        egret.Tween.get(this.card4).wait(630).to({x:this.card4.x-293,y:this.card4.y+24},500)
        egret.Tween.get(this.card14).wait(630).to({x:this.card14.x-293,y:this.card14.y+24},500)

        egret.Tween.get(this.card5).wait(700).to({x:this.card5.x-285,y:this.card5.y+24},500)
        egret.Tween.get(this.card15).wait(700).to({x:this.card15.x-285,y:this.card15.y+24},500)

        egret.Tween.get(this.card6).wait(770).to({x:this.card6.x+364,y:this.card6.y-192},500)
        egret.Tween.get(this.card16).wait(770).to({x:this.card16.x+364,y:this.card16.y-192},500)

        egret.Tween.get(this.card7).wait(830).to({x:this.card7.x-78,y:this.card7.y+12},500)
        egret.Tween.get(this.card17).wait(830).to({x:this.card17.x-78,y:this.card17.y+12},500)

        egret.Tween.get(this.card8).wait(900).to({x:this.card8.x-70,y:this.card8.y+12},500)
        egret.Tween.get(this.card18).wait(900).to({x:this.card18.x-70,y:this.card18.y+12},500)

        egret.Tween.get(this.card9).wait(970).to({x:this.card9.x-62,y:this.card9.y+12},500)
        egret.Tween.get(this.card19).wait(970).to({x:this.card19.x-62,y:this.card19.y+12},500)
    }
    composeAni(){
        this.composeBtn.icon = "compBtn_png"
        this.composeBtn.touchChildren = false;
        this.composeBtn.touchEnabled = false;
        egret.Tween.get(this.card1).wait(500).to({x:this.card1.x+150,y:this.card1.y+206},330);
        egret.Tween.get(this.card11).wait(500).to({x:this.card11.x+150,y:this.card11.y+206},330);

        egret.Tween.get(this.card2).wait(570).to({y:this.card2.y+206},330)
        egret.Tween.get(this.card12).wait(570).to({y:this.card12.y+206},330)

        egret.Tween.get(this.card3).wait(630).to({x:this.card3.x-150,y:this.card3.y+206},330)
        egret.Tween.get(this.card13).wait(630).to({x:this.card13.x-150,y:this.card13.y+206},330)

        egret.Tween.get(this.card4).wait(700).to({x:this.card4.x+150},330)
        egret.Tween.get(this.card14).wait(700).to({x:this.card14.x+150},330)

        // egret.Tween.get(this.card5).wait(600).to({x:this.card5.x-285,y:this.card5.y+24},330)
        // egret.Tween.get(this.card15).wait(600).to({x:this.card15.x-285,y:this.card15.y+24},330)

        egret.Tween.get(this.card6).wait(770).to({x:this.card6.x-150},330)
        egret.Tween.get(this.card16).wait(770).to({x:this.card16.x-150},330)

        egret.Tween.get(this.card7).wait(830).to({x:this.card7.x+150,y:this.card7.y-206},330)
        egret.Tween.get(this.card17).wait(830).to({x:this.card17.x+150,y:this.card17.y-206},330)

        egret.Tween.get(this.card8).wait(900).to({y:this.card8.y-206},330)
        egret.Tween.get(this.card18).wait(900).to({y:this.card18.y-206},330)

        egret.Tween.get(this.card9).wait(970).to({x:this.card9.x-150,y:this.card9.y-206},330)
        egret.Tween.get(this.card19).wait(970).to({x:this.card19.x-150,y:this.card19.y-206},330)

        for(let i = 1;i<10;i++){
            egret.Tween.get(this["card"+i]).wait(1330).to({alpha:0},330);
            // egret.Tween.get(this["card1"+i]).wait(1330).to({alpha:0},330);
        }
        setTimeout(()=>{
                this.composeGroup.visible = false;
                this.loadSVGA();

        },1660)
        // egret.Tween.get(this.composeGroup)
        // .wait(1660)
        // .call(()=>{
        //     this.composeGroup.visible = false;
        //     this.loadSVGA();
            
        // })
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame2, this)

    }
    onEnterFrame2(){
        this.btnlight.rotation+= 5;
        this.light.rotation+=1
    }

    loadSVGA(){
        this.composeGroup.visible = false;
        let SvgaData = SVGACtrl.instance.getSVGAByName("hecheng");
        let svga = new window['SVGA'].EgretMovieClip(SvgaData);
        // svga.anchorOffsetX = this.card5.width
        // svga.anchorOffsetY =this.card5.height
        // svga.x = this.card5.x-25;
        // svga.y = this.card5.y;
        this.addChild(svga);
        this.finishGroup.visible = true;
        
        setTimeout(()=>{
            // egret.Tween.get(this.cardGroup)
            //             .set({alpha:0})
            //             .to({alpha:1},300)
            for(let i = 0;i<this.carddata.length;i++){
                if(this.carddata[i].type == 0){
                    this.comcard.source = this.carddata[i].image;
                }
            }
            
            
            this.removeChild(svga);
            let chaojiDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
            let chaojiDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.chaojiBtnExposure = Buried.createExposure(chaojiDpmOut, chaojiDcmOut);

            NetManager.ins.showLog(this.chaojiBtnExposure);
            
        },1100)
    }
    onTap_closeBtn(){
        Waiting.instance.show()
        iqiyi.getAllCards((ss)=>{
            if(!ss){
                // ToastCtrl.instance.show("网络异常，请重试");
                if(DataManager.ins.getData("getAllCards").desc){
                    ToastCtrl.instance.show(DataManager.ins.getData("getAllCards").desc)
                }else{
                    PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                }
                return;
            }
            let carddata = DataManager.ins.getData("getAllCards").data;
            iqiyi.getCompletedNum((sss)=>{
                if(!sss){
                    // ToastCtrl.instance.show("网络异常，请重试");
                    if(DataManager.ins.getData("getCompletedNum").desc){
                        ToastCtrl.instance.show(DataManager.ins.getData("getCompletedNum").desc)
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                    }
                    return;
                }
                let numdata = DataManager.ins.getData("getCompletedNum").data;
                iqiyi.getTasks((ssss)=>{
                    if(!ssss){
                        // ToastCtrl.instance.show("网络异常，请重试");
                        if(DataManager.ins.getData("getTasks").desc){
                            ToastCtrl.instance.show(DataManager.ins.getData("getTasks").desc)
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                        }
                        return;
                    }
                    let taskdata = DataManager.ins.getData("getTasks").data;
                    iqiyi.getCollectNum((res)=>{
                        Waiting.instance.hide()
                        if (!ssss) {
                            // ToastCtrl.instance.show("网络异常，请重试");
                            if(DataManager.ins.getData("getCollectNum").desc){
                                ToastCtrl.instance.show(DataManager.ins.getData("getCollectNum").desc)
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.NO_NETWORK_PANEL);
                            }
                            return;
                        }
                        let collectdata = DataManager.ins.getData("getCollectNum").data;
                        let data = { carddata: carddata, numdata: numdata,collectdata:collectdata, taskdata: taskdata, taskY: true }
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE, data);
                        this.hidePanel()
                    }, window["CFG"].activityId)
                },window["CFG"].activityId)
            },window["CFG"].activityId)
        },window["CFG"].activityId)
    }


    removeEvents(){
        super.removeEvents();
        this.clearTap(this.composeBtn,this.onTap_composeBtn);
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
    }
}