"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var Waiting_1 = require("../waiting/Waiting");
var NetConst_1 = require("../NetConst");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var RankPanel = (function (_super) {
    __extends(RankPanel, _super);
    function RankPanel() {
        var _this = _super.call(this) || this;
        Waiting_1.default.instance.hide();
        return _this;
    }
    Object.defineProperty(RankPanel.prototype, "skinKey", {
        get: function () { return 'Rank'; },
        enumerable: true,
        configurable: true
    });
    RankPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.showPanel();
    };
    RankPanel.prototype.onTap_closeBtn = function (e) {
        var _this = this;
        Waiting_1.default.instance.show();
        NetConst_1.default.ajaxElement(function (s) {
            Waiting_1.default.instance.hide();
            _this.hidePanel();
            sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
        });
    };
    RankPanel.prototype.showPanel = function () {
        if (DataManager_1.DataManager.ins.getData('recentRankList').data) {
            var i = 0;
            var ranklength = 0;
            if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList.length <= 50) {
                ranklength = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList.length;
            }
            else {
                ranklength = 50;
            }
            for (i = 1; i <= ranklength; i++) {
                if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].rank == 1) {
                    var img = new eui.Image();
                    img.source = "first_png";
                    img.x = 53;
                    img.y = 0;
                    img.width = 47;
                    img.height = 52;
                    this.rankGroup.addChild(img);
                }
                else if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].rank == 2) {
                    var img = new eui.Image();
                    img.source = "second_png";
                    img.x = 53;
                    img.y = 72;
                    img.width = 47;
                    img.height = 52;
                    this.rankGroup.addChild(img);
                }
                else if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].rank == 3) {
                    var img = new eui.Image();
                    img.source = "third_png";
                    img.x = 53;
                    img.y = 144;
                    img.width = 47;
                    img.height = 52;
                    this.rankGroup.addChild(img);
                }
                else {
                    var img = new eui.Image();
                    img.source = "point_png";
                    img.x = 57;
                    img.y = 72 * (i - 1);
                    img.width = 40;
                    img.height = 40;
                    this.rankGroup.addChild(img);
                    var ranknum = new eui.Label();
                    ranknum.text = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].rank;
                    ranknum.size = 24;
                    ranknum.x = img.x + img.width / 2 - ranknum.width / 2;
                    ranknum.y = img.y + img.height / 2 - ranknum.height / 2;
                    ranknum.textColor = parseInt("040b34");
                    this.rankGroup.addChild(ranknum);
                }
                var imgline = new eui.Image();
                imgline.source = "underline_png";
                imgline.x = 53;
                imgline.y = 60 + (i - 1) * 72;
                imgline.width = 548;
                imgline.height = 1;
                this.rankGroup.addChild(imgline);
                var rankid = new eui.Label();
                rankid.text = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].uid;
                rankid.x = 193;
                rankid.y = (i - 1) * 72;
                rankid.size = 24;
                rankid.width = 230;
                rankid.height = 51;
                rankid.textColor = parseInt("ffffff", 16);
                rankid.textAlign = "center";
                rankid.verticalAlign = "middle";
                this.rankGroup.addChild(rankid);
                var rankscore = new eui.Label();
                rankscore.text = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i - 1].maxScore;
                rankscore.width = 203;
                rankscore.height = 51;
                rankscore.x = 423;
                rankscore.y = (i - 1) * 72;
                rankscore.size = 24;
                rankscore.textColor = parseInt("ffffff", 16);
                rankscore.textAlign = "center";
                rankscore.verticalAlign = "middle";
                this.rankGroup.addChild(rankscore);
            }
            if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo) {
                if (DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.rank <= 5000) {
                    this.myrank.size = 36;
                    this.myrank.text = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.rank;
                }
                else {
                    this.myrank.size = 24;
                    this.myrank.text = "暂未上榜";
                }
                this.mycake.text = DataManager_1.DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.maxScore;
            }
        }
    };
    RankPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    };
    return RankPanel;
}(Panel_1.default));
exports.default = RankPanel;
__reflect(RankPanel.prototype, "\"e:/zqty/egret/src/rankPanel/RankPanel\".RankPanel");
//# sourceMappingURL=RankPanel.js.map