"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = require("../views/Scene");
var GameConst_1 = require("../GameConst");
var sceneTypes_1 = require("../types/sceneTypes");
var NetConst_1 = require("../NetConst");
var toastCtrl_1 = require("../ctrls/toastCtrl");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var Waiting_1 = require("../waiting/Waiting");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var PlayScene = (function (_super) {
    __extends(PlayScene, _super);
    function PlayScene() {
        var _this = _super.call(this) || this;
        _this.distance = 0;
        _this.speed = 0;
        _this.line = 2;
        _this.touchtime = 0;
        _this.createtime = 0;
        _this.collision = 0;
        _this.getcake = 0;
        _this.prefabPool = [];
        _this.isend = false;
        //间隔时间
        _this.interval = window['interval'];
        _this.isinitPrefab = false;
        //this.initUI();
        PlayScene.instance = _this;
        _this.guideCount();
        return _this;
    }
    Object.defineProperty(PlayScene.prototype, "skinKey", {
        get: function () { return "Play"; },
        enumerable: true,
        configurable: true
    });
    // 引导倒计时 3 2 1 go!
    PlayScene.prototype.guideCount = function () {
        this.runnum2.text = "已行驶:0km";
        this.blocknum2.text = "路障:0个";
        this.cakenum2.text = "月饼:0个";
        this.distancenum.visible = false;
        panelCtrl_1.default._instance.show(sceneTypes_1.ModuleTypes.COUNTDOWN_PANEL);
    };
    PlayScene.prototype.onEnterFrame = function () {
        var _this = this;
        var i = Math.floor(this.distance / window['kilometer']);
        switch (i) {
            case 0:
                this.speed = window['speed'];
                break;
            case 1:
                this.speed = window['speed'];
                break;
            case 2:
                this.speed = window['speed'] + window['speedRate'];
                this.interval = 1500;
                break;
            case 3:
                //this.speed = window['speed'];
                break;
            case 4:
                //this.speed = window['speed'];
                break;
            case 5:
                this.speed = window['speed'] + (window['speedRate'] * 2);
                this.interval = 1200;
                break;
            default:
                if (i % 5 == 0) {
                    this.speed = window['speed'] + window['speedRate'] * (i / 5 + 1);
                    if (this.interval > 500) {
                        this.interval = 1200 - window['cutinterval'] * (i / 5);
                    }
                }
                break;
        }
        this.showGuidepost(i);
        this.distance += this.speed;
        this.bg1.y += this.speed;
        this.bg2.y += this.speed;
        if (this.bg1.y >= this.bg1.height) {
            this.bg1.y = this.bg2.y - 1622;
        }
        if (this.bg2.y >= this.bg2.height) {
            this.bg2.y = this.bg1.y - 1622;
        }
        this.runnum2.text = "已行驶:" + i + "km";
        // 设置速度  超出屏幕移除  
        if (this.isinitPrefab && this.prefabPool.length > 0) {
            if (this.collision < 3) {
                var _loop_1 = function (i_1) {
                    this_1.prefabPool[i_1].y += this_1.speed;
                    if (this_1.prefabPool[i_1].y > 1624) {
                        if (this_1.prefabPool[i_1].$parent) {
                            this_1.playGroup.removeChild(this_1.prefabPool[i_1]);
                        }
                        GameConst_1.default.arr.removeEle(this_1.prefabPool[i_1], this_1.prefabPool);
                    }
                    else if (this_1.prefabPool[i_1].y + this_1.prefabPool[i_1].height >= this_1.runcar.y && this_1.prefabPool[i_1].lane == this_1.line && this_1.prefabPool[i_1].y <= this_1.runcar.y + this_1.runcar.height) {
                        if (this_1.prefabPool[i_1].type == 1) {
                            if (this_1.collision < 2) {
                                var ele_1 = this_1.prefabPool[i_1];
                                this_1.playGroup.addChild(ele_1);
                                GameConst_1.default.arr.removeEle(this_1.prefabPool[i_1], this_1.prefabPool);
                                egret.Tween.get(ele_1)
                                    .to({ rotation: 180, x: ele_1.x + 300, alpha: 0 }, 300)
                                    .call(function () {
                                    _this.playGroup.removeChild(ele_1);
                                });
                                this_1.collision += 1;
                                console.log("collision" + this_1.collision);
                            }
                            else {
                                this_1.collision += 1;
                                this_1.speed = 0;
                                this_1.gameOver();
                            }
                            //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                        }
                        else if (this_1.prefabPool[i_1].type == 2) {
                            if (this_1.collision < 2) {
                                var ele_2 = this_1.prefabPool[i_1];
                                this_1.playGroup.addChild(ele_2);
                                GameConst_1.default.arr.removeEle(this_1.prefabPool[i_1], this_1.prefabPool);
                                egret.Tween.get(ele_2)
                                    .to({ rotation: 180, x: ele_2.x + 300, alpha: 0, scaleX: 0.6, scaleY: 0.6 }, 300)
                                    .call(function () {
                                    _this.playGroup.removeChild(ele_2);
                                });
                                this_1.collision += 1;
                                console.log("collision" + this_1.collision);
                            }
                            else {
                                this_1.collision += 1;
                                this_1.speed = 0;
                                this_1.gameOver();
                            }
                            //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                        }
                        else if (this_1.prefabPool[i_1].type == 3) {
                            if (this_1.prefabPool[i_1].y + (this_1.prefabPool[i_1].height * 2 / 3) >= this_1.runcar.y && this_1.prefabPool[i_1].lane == this_1.line) {
                                var ele_3 = this_1.prefabPool[i_1];
                                this_1.playGroup.addChild(ele_3);
                                GameConst_1.default.arr.removeEle(this_1.prefabPool[i_1], this_1.prefabPool);
                                egret.Tween.get(ele_3)
                                    .set({ scaleX: 1.1, scaleY: 1.1 })
                                    .to({ x: 20, y: 140, alpha: 0, scaleX: 0.6, scaleY: 0.6 }, 500)
                                    .call(function () {
                                    _this.playGroup.removeChild(ele_3);
                                });
                                //GameConst.arr.removeEle(this.prefabPool[i],this.prefabPool);
                                this_1.getcake += 2;
                            }
                        }
                    }
                };
                var this_1 = this;
                for (var i_1 = this.prefabPool.length - 1; i_1 >= 0; i_1--) {
                    _loop_1(i_1);
                }
            }
            else {
                this.speed = 0;
                this.gameOver();
            }
        }
        //生成新障碍
        var now = Date.now();
        if (now - this.createtime > this.interval) {
            var randomtype = Math.floor(Math.random() * 3) + 1;
            var randomlane = Math.floor(Math.random() * 3) + 1;
            var prefab = this.creatPrefab(randomtype, randomlane);
            this.prefabPool.push(prefab);
            this.playGroup.addChildAt(prefab, 1);
            this.createtime = now;
        }
        this.blocknum2.text = "路障:" + this.collision + "个";
        this.cakenum2.text = "月饼:" + this.getcake + "个";
    };
    PlayScene.prototype.showGuidepost = function (num) {
        if (num < 5 || num % 5 == 4) {
            if (this.distance + this.runcar.y >= (num + 1) * window['kilometer']) {
                if (this.distancenum.visible) {
                }
                else {
                    this.distancenum.visible = true;
                    this.distancenum.text = (num + 1) + "km";
                    this.distancenum.y = 0;
                }
            }
        }
        this.distancenum.y += this.speed;
        if (this.distancenum.y > GameConst_1.default.stage.stageHeight) {
            this.distancenum.visible = false;
        }
    };
    PlayScene.prototype.getEnterFrame = function () {
        this.initPrefab();
        this.onTap(this.goleft, this.onTap_goleft);
        this.onTap(this.goright, this.onTap_goright);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    PlayScene.prototype.onTap_goleft = function () {
        var now = Date.now();
        if (now - this.touchtime > 200) {
            console.log("goleft");
            if (this.line > 1) {
                this.line -= 1;
            }
            console.log(this.line);
            if (this.line == 1) {
                egret.Tween.get(this.runcar)
                    .to({ x: 82 }, 200);
            }
            else if (this.line == 2) {
                egret.Tween.get(this.runcar)
                    .to({ x: 295 }, 200);
            }
            this.touchtime = now;
        }
    };
    PlayScene.prototype.onTap_goright = function () {
        console.log("goright");
        var now = Date.now();
        if (now - this.touchtime > 200) {
            if (this.line < 3) {
                this.line += 1;
            }
            if (this.line == 2) {
                egret.Tween.get(this.runcar)
                    .to({ x: 295 }, 200);
            }
            else if (this.line == 3) {
                egret.Tween.get(this.runcar)
                    .to({ x: 509 }, 200);
            }
            this.touchtime = now;
        }
    };
    PlayScene.prototype.initPrefab = function () {
        var block1 = this.creatPrefab(1, 1);
        block1.y = 430;
        this.prefabPool.push(block1);
        this.playGroup.addChildAt(block1, 1);
        var block2 = this.creatPrefab(2, 3);
        block2.y = 460;
        this.prefabPool.push(block2);
        this.playGroup.addChildAt(block2, 1);
        var cake = this.creatPrefab(3, 2);
        cake.y = 56;
        this.prefabPool.push(cake);
        this.playGroup.addChildAt(cake, 1);
        this.isinitPrefab = true;
    };
    PlayScene.prototype.creatPrefab = function (id, lane) {
        var prefab;
        if (id == 1) {
            prefab = new eui.Component();
            prefab.skinName = "roadblockSkin";
            if (lane == 1) {
                prefab.x = 82;
            }
            else if (lane == 2) {
                prefab.x = 308;
            }
            else if (lane == 3) {
                prefab.x = 536;
            }
            prefab.y = 0;
        }
        else if (id == 2) {
            prefab = new eui.Component();
            prefab.skinName = "roadcarSkin";
            if (lane == 1) {
                prefab.x = 110;
            }
            else if (lane == 2) {
                prefab.x = 330;
            }
            else if (lane == 3) {
                prefab.x = 550;
            }
            prefab.y = 0;
        }
        else if (id == 3) {
            prefab = new eui.Component();
            prefab.skinName = "mooncakeSkin";
            if (lane == 1) {
                prefab.x = 37;
            }
            else if (lane == 2) {
                prefab.x = 253;
            }
            else if (lane == 3) {
                prefab.x = 469;
            }
            prefab.y = 0;
        }
        prefab.type = id;
        prefab.lane = lane;
        return prefab;
    };
    PlayScene.prototype.TargetMove = function () {
        if (this.prefabtarget) {
            this.prefabtarget.y += this.speed;
        }
    };
    PlayScene.prototype.gameOver = function () {
        var _this = this;
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.distance = Math.floor(this.distance / window['kilometer']);
        NetConst_1.default.ngameSubmit(function (s) {
            if (!s) {
                toastCtrl_1.default.instance.show("活动太火爆了，请稍后再来");
                NetConst_1.default.ajaxElement(function (s) {
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
                });
                return;
            }
            else {
                var data = { distance: _this.distance, blocknum: _this.collision, cakenum: _this.getcake };
                Waiting_1.default.instance.show();
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.END_PANEL, data);
            }
        }, DataManager_1.DataManager.ins.getData("doJoin").data, this.getcake, [], [], DataManager_1.DataManager.ins.getData("getNgameStartStatus").data.submitToken, window['rankId']);
    };
    PlayScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.clearTap(this.goleft, this.onTap_goleft);
        this.clearTap(this.goright, this.onTap_goright);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    return PlayScene;
}(Scene_1.default));
exports.default = PlayScene;
__reflect(PlayScene.prototype, "\"e:/zqty/egret/src/playScene/PlayScene\".PlayScene");
//# sourceMappingURL=PlayScene.js.map