"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetConst_1 = require("../NetConst");
var Waiting_1 = require("../waiting/Waiting");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var toastCtrl_1 = require("../ctrls/toastCtrl");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var getOptionImgSize_1 = require("../prize/data/getOptionImgSize");
var ImgSizeType_1 = require("../prize/data/ImgSizeType");
var LotteryType_1 = require("../../libs/tw/enum/LotteryType");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var GameConst_1 = require("../GameConst");
var EndPanel = (function (_super) {
    __extends(EndPanel, _super);
    function EndPanel(data) {
        var _this = _super.call(this) || this;
        _this.cakenum = 0;
        _this.blocknum = 0;
        _this.distancenum = 0;
        _this.initUI(data);
        return _this;
    }
    Object.defineProperty(EndPanel.prototype, "skinKey", {
        get: function () { return 'End'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EndPanel.prototype, "exposure", {
        get: function () {
            return;
        },
        enumerable: true,
        configurable: true
    });
    EndPanel.prototype.initUI = function (data) {
        var _this = this;
        this.endnoprizeGroup.visible = false;
        this.endprizeGroup.visible = false;
        this.closeBtn.visible = false;
        this.cakenum = data.cakenum;
        this.blocknum = data.blocknum;
        this.distancenum = data.distance;
        NetConst_1.default.getOrderStatus(function (ss) {
            Waiting_1.default.instance.hide();
            if (!ss) {
                _this.endnoprizeGroup.visible = true;
                _this.NoPrizePop();
                return;
            }
            if (DataManager_1.DataManager.ins.getData("getOrderStatus") && DataManager_1.DataManager.ins.getData("getOrderStatus").data && DataManager_1.DataManager.ins.getData("getOrderStatus").data.lottery && DataManager_1.DataManager.ins.getData("getOrderStatus").data.lottery.type !== "thanks") {
                _this.endprizeGroup.visible = true;
                _this.PrizePop();
            }
            else {
                _this.endnoprizeGroup.visible = true;
                _this.NoPrizePop();
            }
        }, DataManager_1.DataManager.ins.getData("doJoin").data, function () {
            return DataManager_1.DataManager.ins.getData("getOrderStatus").code == "C000000001";
        });
    };
    EndPanel.prototype.NoPrizePop = function () {
        this.juliLab.text = this.distancenum + "km";
        this.cakeLab.text = "共收集        ：" + this.cakenum + "个";
        this.blockLab.text = "碰到障碍        ：" + this.blocknum + "个";
        this.closeBtn.visible = true;
        this.closeBtn.y = 169;
        // this.onTap(this.getRankBtn,this.onTap_Rank);
        // this.onTap(this.closeBtn,this.onTap_closeBtn);
    };
    EndPanel.prototype.onTap_Rank = function () {
        Waiting_1.default.instance.show();
        NetConst_1.default.recentRankList(function (s) {
            if (!s) {
                // 容错
                toastCtrl_1.default.instance.show("活动太火爆了，请稍后再来");
                return;
            }
            console.log(s);
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RANK_PANEL);
        }, window['rankId'], DataManager_1.DataManager.ins.customCfgData.actId);
    };
    Object.defineProperty(EndPanel.prototype, "lottery", {
        get: function () { return DataManager_1.DataManager.ins.getData("getOrderStatus").data.lottery; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EndPanel.prototype, "picWidth", {
        get: function () { return 250; },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(EndPanel.prototype, "picBigWidth", {
        get: function () { return 500; },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(EndPanel.prototype, "bigPicRatio", {
        get: function () { return 640 / 300; },
        enumerable: true,
        configurable: true
    });
    EndPanel.prototype.PrizePop = function () {
        this.julilab.text = this.distancenum + "km";
        this.cakelab.text = "共收集        ：" + this.cakenum + "个";
        this.blocklab.text = "碰到障碍        ：" + this.blocknum + "个";
        this.closeBtn.visible = true;
        this.closeBtn.y = 39;
        //奖品显示
        if (this.lottery) {
            var sizeType = getOptionImgSize_1.default(this.lottery);
            if (ImgSizeType_1.default.BIG === sizeType) {
                this.prizeimg.width = this.picBigWidth;
                this.prizeimg.height = this.picBigWidth / this.bigPicRatio;
            }
            else {
                this.prizeimg.width = this.prizeimg.height = this.picWidth;
            }
            this.prizeimg.source = this.lottery.imgUrl;
            this.prizeimg.anchorOffsetX = 250 / 2;
            this.prizeimg.anchorOffsetY = 250 / 2;
        }
        // this.onTap(this.closeBtn,this.onTap_closeBtn);
        // this.onTap(this.restartBtn,this.onTap_closeBtn);
        // this.onTap(this.getprizeBtn,this.onTap_getPrizeBtn);
    };
    EndPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.onTap(this.getRankBtn, this.onTap_Rank);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.restartBtn, this.onTap_closeBtn);
        this.onTap(this.getprizeBtn, this.onTap_getPrizeBtn);
    };
    EndPanel.prototype.onTap_closeBtn = function (e) {
        var _this = this;
        Waiting_1.default.instance.show();
        NetConst_1.default.ajaxElement(function (s) {
            Waiting_1.default.instance.hide();
            _this.hidePanel();
            sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
        });
    };
    EndPanel.prototype.onTap_getPrizeBtn = function () {
        if (this.lottery.type == LotteryType_1.LotteryType.COUPON || this.lottery.type == LotteryType_1.LotteryType.LUCKY) {
            var isIOS = GameConst_1.default.isIOS();
            if (isIOS) {
                window.location.href = this.lottery.iosDownloadUrl;
            }
            else {
                window.location.href = this.lottery.androidDownloadUrl;
            }
            if (this.lottery.type == "lucky") {
                NetManager_1.NetManager.ins.spmclick(this.exposure);
            }
        }
        else {
            window.location.href = this.lottery.link;
        }
    };
    EndPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.clearTap(this.getRankBtn, this.onTap_Rank);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.restartBtn, this.onTap_closeBtn);
        this.clearTap(this.getprizeBtn, this.onTap_getPrizeBtn);
    };
    return EndPanel;
}(Panel_1.default));
exports.default = EndPanel;
__reflect(EndPanel.prototype, "\"e:/zqty/egret/src/endPanel/EndPanel\".EndPanel");
//# sourceMappingURL=EndPanel.js.map