"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (type, data) {
        if (this._currentScene) {
            this._currentScene.destroy();
            this._parent.removeChild(this._currentScene);
        }
        var cls = this._sceneClassMap[type];
        var scene = data ? new cls(data) : new cls();
        if (data) {
            scene.start(data);
        }
        else {
            scene.start();
        }
        this.addToStage(scene);
    };
    SceneCtrl.prototype.addToStage = function (scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    SceneCtrl.prototype.registerClass = function (name, definition) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = definition;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;
__reflect(SceneCtrl.prototype, "\"e:/zqty/egret/src/ctrls/sceneCtrl\".SceneCtrl");
//# sourceMappingURL=sceneCtrl.js.map