"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var MovieClipCtrl = (function () {
    function MovieClipCtrl() {
        this.movieClipPool = [];
        // 影片剪辑的配置属性
        this.movieClipNamePool = [];
    }
    Object.defineProperty(MovieClipCtrl, "instance", {
        get: function () {
            return MovieClipCtrl._instance || (MovieClipCtrl._instance = new MovieClipCtrl());
        },
        enumerable: true,
        configurable: true
    });
    // 初始化
    MovieClipCtrl.prototype.init = function () {
        this.initMovieClip();
    };
    // 初始化影片剪辑
    MovieClipCtrl.prototype.initMovieClip = function () {
        for (var m = 0; m < this.movieClipNamePool.length; m++) {
            this.ayncLoad2Mc(this.movieClipNamePool[m].name + "_json");
        }
    };
    // 异步加载动画资源
    MovieClipCtrl.prototype.ayncLoad2Mc = function (resname) {
        RES.getResAsync(resname, this.onLoad.bind(this), this);
    };
    // 加载完的回调
    MovieClipCtrl.prototype.onLoad = function (data, key) {
        var scope = this;
        for (var m = 0; m < scope.movieClipNamePool.length; m++) {
            if (key == scope.movieClipNamePool[m].name + "_json") {
                scope.ayncLoad2Mc(scope.movieClipNamePool[m].name + "_png");
            }
            else if (key == scope.movieClipNamePool[m].name + "_png") {
                for (var i = 0; i < scope.movieClipNamePool[m].num; i++) {
                    var data2mc = RES.getRes(scope.movieClipNamePool[m].name + "_json");
                    var texture2mc = RES.getRes(scope.movieClipNamePool[m].name + "_png");
                    var mcFactory = new egret.MovieClipDataFactory(data2mc, texture2mc);
                    var mc = new egret.MovieClip(mcFactory.generateMovieClipData("" + scope.movieClipNamePool[m].dataName));
                    mc.name = scope.movieClipNamePool[m].name + "_" + i;
                    scope.movieClipPool.push(mc);
                }
            }
        }
        console.log(scope.movieClipNamePool);
    };
    // 获取单个影片剪辑
    MovieClipCtrl.prototype.getMovieClipByName = function (name) {
        for (var mc = 0; mc < this.movieClipPool.length; mc++) {
            if (this.movieClipPool[mc].name == name) {
                return this.movieClipPool[mc];
            }
        }
    };
    return MovieClipCtrl;
}());
exports.default = MovieClipCtrl;
__reflect(MovieClipCtrl.prototype, "\"e:/zqty/egret/src/ctrls/MovieClipCtrl\".MovieClipCtrl");
//# sourceMappingURL=MovieClipCtrl.js.map