"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 场景转换动画库
 */
var SceneTransitionAni = (function () {
    function SceneTransitionAni() {
    }
    // 遮罩场景切换
    SceneTransitionAni.open = function (callback, scene, type, maskX, maskY) {
        if (type === void 0) { type = 'circle'; }
        if (maskX === void 0) { maskX = 375; }
        if (maskY === void 0) { maskY = 1206 / 2; }
        switch (type) {
            default:
            case 'circle':
                var mask_1 = new egret.Shape();
                mask_1.graphics.beginFill(0xffffff, 1);
                mask_1.graphics.drawCircle(0, 0, 1624);
                mask_1.graphics.endFill();
                mask_1.x = maskX;
                mask_1.y = maskY;
                scene.mask = mask_1;
                scene.addChild(mask_1);
                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,
                var changer_1 = { radius: 0 };
                var changerTW = egret.Tween.get(changer_1, {
                    onChange: function () {
                        mask_1.graphics.clear();
                        mask_1.graphics.beginFill(0xFFFFFF, 1);
                        mask_1.graphics.drawCircle(0, 0, changer_1.radius);
                        mask_1.graphics.endFill();
                    }
                });
                changerTW.wait(100).to({ radius: 1000 }, 500).call(function () {
                    scene.removeChild(mask_1);
                    scene.mask = null;
                    callback();
                });
                break;
        }
    };
    SceneTransitionAni.close = function (callback, scene, type, maskX, maskY) {
        if (type === void 0) { type = 'circle'; }
        if (maskX === void 0) { maskX = 375; }
        if (maskY === void 0) { maskY = 1206 / 2; }
        switch (type) {
            default:
            case 'circle':
                var mask_2 = new egret.Shape();
                mask_2.graphics.beginFill(0xffffff, 1);
                mask_2.graphics.drawCircle(0, 0, 1624);
                mask_2.graphics.endFill();
                mask_2.x = maskX;
                mask_2.y = maskY;
                scene.mask = mask_2;
                scene.addChild(mask_2);
                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,
                var changer_2 = { radius: 1000 };
                var changerTW = egret.Tween.get(changer_2, {
                    onChange: function () {
                        mask_2.graphics.clear();
                        mask_2.graphics.beginFill(0xFFFFFF, 1);
                        mask_2.graphics.drawCircle(0, 0, changer_2.radius);
                        mask_2.graphics.endFill();
                    }
                });
                changerTW.to({ radius: 0 }, 500).wait(100).call(function () {
                    scene.removeChild(mask_2);
                    scene.mask = null;
                    callback();
                });
                break;
        }
    };
    SceneTransitionAni.closeAndOpen = function (callback, scene, type, maskX, maskY) {
        if (type === void 0) { type = 'circle'; }
        if (maskX === void 0) { maskX = 375; }
        if (maskY === void 0) { maskY = 1206 / 2; }
        switch (type) {
            default:
            case 'circle':
                var mask_3 = new egret.Shape();
                mask_3.graphics.beginFill(0xffffff, 1);
                mask_3.graphics.drawCircle(0, 0, 1624);
                mask_3.graphics.endFill();
                mask_3.x = maskX;
                mask_3.y = maskY;
                scene.mask = mask_3;
                scene.addChild(mask_3);
                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,
                var changer_3 = { radius: 1000 };
                var changerTW = egret.Tween.get(changer_3, {
                    onChange: function () {
                        mask_3.graphics.clear();
                        mask_3.graphics.beginFill(0xFFFFFF, 1);
                        mask_3.graphics.drawCircle(0, 0, changer_3.radius);
                        mask_3.graphics.endFill();
                    }
                });
                changerTW.to({ radius: 0 }, 500).wait(100).to({ radius: 1200 }).call(function () {
                    scene.removeChild(mask_3);
                    scene.mask = null;
                    callback();
                });
                break;
        }
    };
    return SceneTransitionAni;
}());
exports.default = SceneTransitionAni;
__reflect(SceneTransitionAni.prototype, "\"e:/zqty/egret/src/SceneTransitionAni\".SceneTransitionAni");
//# sourceMappingURL=SceneTransitionAni.js.map