"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 游戏常量
 */
var GameConst = (function () {
    function GameConst() {
    }
    // 二次贝塞尔,用于做曲线运动
    GameConst.bezier = function (t, p0, p1, p2) {
        // (1-t)^2 P0 + 2(1-t)tP1+ t^2P2
        return Math.pow(1 - t, 2) * p0 + 2 * (1 - t) * t * p1 + Math.pow(t, 2) * p2;
    };
    // 计算距离
    GameConst.distance = function (obj1, obj2) {
        var distance = Math.sqrt(Math.pow(obj1.x - obj2.x, 2) + Math.pow(obj1.y - obj2.y, 2));
        return distance;
    };
    // 重新随机排序
    GameConst.randomsort = function (a, b) {
        return Math.random() > .5 ? -1 : 1;
    };
    /**
     * 随机数字区间里的一个数
     * @param n1 开始区间
     * @param n2 结束区间
     */
    GameConst.randomNum = function (n1, n2) {
        if (arguments.length === 2) {
            return Math.round(n1 + Math.random() * (n2 - n1));
        }
        else if (arguments.length === 1) {
            return Math.round(Math.random() * n1);
        }
        else {
            return Math.round(Math.random() * 255);
        }
    };
    // 是否是IOS系统
    GameConst.isIOS = function () {
        var u = navigator.userAgent;
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    };
    // 是否招行app端内
    GameConst.isMPBank = function () {
        var ua = navigator.userAgent;
        if (ua.indexOf('MPBank') > -1)
            return true;
        else
            return false;
    };
    // 从url里取字段
    GameConst.getQueryString = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null)
            return unescape(r[2]);
        return null;
    };
    /**
     * 画圆
     * @param x
     * @param y
     * @param radius
     * @param color
     * @param alpha
     */
    GameConst.drawCircle = function (x, y, radius, color, alpha) {
        if (color === void 0) { color = 0x000000; }
        if (alpha === void 0) { alpha = 0.7; }
        var circle = new egret.Shape();
        circle.graphics.beginFill(color, alpha);
        circle.graphics.drawArc(x, y, radius, 0, Math.PI * 2, true);
        circle.graphics.endFill();
        return circle;
    };
    /**
     * 画方
     * @param x
     * @param y
     * @param w
     * @param h
     * @param color
     * @param alpha
     */
    GameConst.drawRect = function (x, y, w, h, color, alpha) {
        if (color === void 0) { color = 0x000000; }
        if (alpha === void 0) { alpha = 0.7; }
        var rect = new egret.Shape();
        rect.graphics.beginFill(color, alpha);
        rect.graphics.drawRect(x, y, w, h);
        rect.graphics.endFill();
        return rect;
    };
    /**
     * 画方
     * @param obj
     * @param color
     * @param alpha
     */
    GameConst.drawRectByObj = function (obj, color, alpha) {
        if (color === void 0) { color = 0x000000; }
        if (alpha === void 0) { alpha = 0.7; }
        var rect = new egret.Shape();
        rect.graphics.beginFill(color, alpha);
        rect.graphics.drawRect(obj.x, obj.y, obj.width, obj.height);
        rect.graphics.endFill();
        return rect;
    };
    /**
     * 判断两个物体是否发生碰撞
     * @param obj0 检测目标1 {x,y,width,height}
     * @param obj1 检测目标2 {x,y,width,height}
     * @param gap 增加判断发生碰撞的间隔距离
     */
    GameConst.collisionDetection = function (obj0, obj1, gap) {
        if (gap === void 0) { gap = 0; }
        var l1 = obj0.x - gap;
        var t1 = obj0.y - gap;
        var r1 = obj0.x + obj0.width + gap;
        var b1 = obj0.y + obj0.height + gap;
        var l2 = obj1.x;
        var t2 = obj1.y;
        var r2 = obj1.x + obj1.width;
        var b2 = obj1.y + obj1.height;
        return !(b1 < t2 || l1 > r2 || t1 > b2 || r1 < l2);
    };
    /**
     * 判断物体是否在区域内
     * @param obj1 区域物体 {x,y,width,height}
     * @param obj2 被检测物体 {x,y,width,height}
     */
    GameConst.contain = function (obj1, obj2) {
        var condition = obj2.x >= obj1.x && obj2.y >= obj1.y && obj2.x + obj2.width <= obj1.x + obj1.width && obj2.y + obj2.height <= obj1.y + obj1.height;
        return condition;
    };
    /**
     * 设置cookie
     * @param name cookie的名称
     * @param value cookie的值
     * @param day cookie的过期时间
     */
    GameConst.setCookie = function (name, value, day) {
        if (day !== 0) {
            var expires = day * 24 * 60 * 60 * 1000;
            var date = new Date(+new Date() + expires);
            document.cookie = name + "=" + escape(value) + ";expires=" + date.toUTCString();
        }
        else {
            document.cookie = name + "=" + escape(value);
        }
    };
    ;
    /**
     * 获取对应名称的cookie
     * @param name cookie的名称
     * @returns {null} 不存在时，返回null
     */
    GameConst.getCookie = function (name) {
        var arr;
        var reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        if (arr = document.cookie.match(reg))
            return unescape(arr[2]);
        else
            return null;
    };
    ;
    /**
    * 删除cookie
    * @param name cookie名称
    */
    GameConst.removeCookie = function (name) {
        this.setCookie(name, 1, -1);
    };
    // 用于控制全局音乐是否播放和音乐按钮状态
    GameConst.isPlayMusic = true;
    // 数组类方法
    GameConst.arr = {
        /**
         * 从数组里移除指定元素
         * @param e 要移除的元素
         * @param arr 目标数组
         */
        removeEle: function (e, arr) {
            var index = arr.indexOf(e);
            if (index >= 0) {
                arr.splice(index, 1);
            }
        },
        /**
         * 数组去重
         * @param arr 数组
         */
        unique: function (arr) {
            if (!arr.length)
                return arr;
            var hash = [];
            hash.push(arr[0]);
            for (var i = 1; i < arr.length; i++) {
                var ele = arr[i];
                if (hash.indexOf(ele) == -1) {
                    hash.push(ele);
                }
            }
            return hash;
        },
        /**
         * 数组随机排序
         * @param arr 数组
         */
        shuffle: function (arr) {
            var i = arr.length;
            while (i) {
                var j = Math.floor(Math.random() * i--); //5555
                _a = [arr[i], arr[j]], arr[j] = _a[0], arr[i] = _a[1];
            }
            return arr;
            var _a;
        },
        /**
         * 从数组里取出第一个
         *  @param arr 目标数组
         */
        getOne: function (arr) {
            if (arr && arr.length) {
                return arr.shift();
            }
            return false;
        },
        /**
         * 从两个数组中取出不同元素
         * @param arr1
         * @param arr2
         */
        getDifference: function (arr1, arr2) {
            return arr1.concat(arr2).filter(function (v, i, arr) {
                return arr.indexOf(v) === arr.lastIndexOf(v);
            });
        },
        /**
         * 从两个数组中取出相同元素
         * @param arr1
         * @param arr2
         */
        getEqual: function (arr1, arr2) {
            var newArr = [];
            for (var i = 0; i < arr2.length; i++) {
                for (var j = 0; j < arr1.length; j++) {
                    if (arr1[j] === arr2[i]) {
                        newArr.push(arr1[j]);
                    }
                }
            }
            return newArr;
        },
        /**
         * 从数组里随机取出一个元素
         * @param e 目标数组
         * @param n
         */
        getRandomOne: function (e, n) {
            return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
        }
    };
    // 时间类方法
    GameConst.time = {
        /**
         * 获取今天零点时间戳
         */
        getTodayMark: function () {
            return new Date(new Date().setHours(0, 0, 0, 0)).getTime();
        },
        /**
        * 倒计时（默认开始时间为当前时间）
        * @param endTime 结束时间 时间戳
        * @returns 例：剩余时间 {d:1, h:16, m:45, s:41} 代表：1天 16小时 45 分钟41 秒
        */
        getEndTime: function (endTime) {
            var startDate = new Date(); //开始时间，当前时间
            var endDate = new Date(endTime); //结束时间，需传入时间参数
            var t = endDate.getTime() - startDate.getTime(); //时间差的毫秒数
            var d = 0, h = 0, m = 0, s = 0;
            if (t >= 0) {
                d = Math.floor(t / 1000 / 3600 / 24);
                h = Math.floor(t / 1000 / 60 / 60 % 24);
                m = Math.floor(t / 1000 / 60 % 60);
                s = Math.floor(t / 1000 % 60);
            }
            return { d: d, h: h, m: m, s: s };
        }
    };
    return GameConst;
}());
exports.default = GameConst;
__reflect(GameConst.prototype, "\"e:/zqty/egret/src/GameConst\".GameConst");
exports.wait = function (time) {
    if (time === void 0) { time = 500; }
    return new Promise(function (resolve) {
        setTimeout(function () {
            resolve();
        }, time);
    });
};
//# sourceMappingURL=GameConst.js.map