"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var GetVisitInfoData_1 = require("./../data/pets/GetVisitInfoData");
var GetSummerInfoData_1 = require("./../data/game/getInfo/GetSummerInfoData");
var GetReviveCardNumData_1 = require("./../data/game/doRevive/GetReviveCardNumData");
var DoReviveData_1 = require("./../data/game/doRevive/DoReviveData");
var DoJoinPlugDrawData_1 = require("./../data/plug/doJoinPlugDraw/DoJoinPlugDrawData");
var NetName_1 = require("./../enum/NetName");
var QuestionSubmitData_1 = require("./../data/custom/questionSbumit/QuestionSubmitData");
var GetCollectRuleData_1 = require("./../data/common/getCollectRule/GetCollectRuleData");
var DatapashData_1 = require("./../data/game/datapash/DatapashData");
var openCollectGoodsPrizeData_1 = require("./../data/common/openCollectGoodsPrize/openCollectGoodsPrizeData");
var TwLang_1 = require("../util/TwLang");
var DoStartData_1 = require("../data/game/doStart/DoStartData");
var GetStartStatusData_1 = require("../data/game/doStart/GetStartStatusData");
var GetInfoData_1 = require("../data/game/getInfo/GetInfoData");
var GetOptionsData_1 = require("../data/game/getOptions/GetOptionsData");
var GetRuleData_1 = require("../data/game/getRule/GetRuleData");
var GetUserTotalScoreData_1 = require("../data/game/getUserTotalScore/GetUserTotalScoreData");
var GuessPokerData_1 = require("../data/game/guessPoker/GuessPokerData");
var GameSubmitData_1 = require("../data/game/submit/GameSubmitData");
var RealTimeRankData_1 = require("../data/game/realtimerank/RealTimeRankData");
var WinRanksData_1 = require("../data/game/winranks/WinRanksData");
var AjaxElementData_1 = require("../data/custom/ajaxElement/AjaxElementData");
var DoJoinData_1 = require("../data/custom/doJoin/DoJoinData");
var AjaxThroughInfoData_1 = require("../data/custom/ajaxThroughInfo/AjaxThroughInfoData");
var GetOrderInfoData_1 = require("../data/custom/getOrderInfo/GetOrderInfoData");
var GetCustomOrderStatusData_1 = require("../data/custom/doJoin/GetCustomOrderStatusData");
var GetRoleData_1 = require("../data/common/getRole/GetRoleData");
var GetCreditsData_1 = require("../data/common/getCredits/GetCreditsData");
var AddTimesForActivityData_1 = require("../data/common/addTimesForActivity/AddTimesForActivityData");
var SetRoleData_1 = require("../data/common/setRole/SetRoleData");
var GameGetSubmitResultData_1 = require("./../data/game/submit/GameGetSubmitResultData");
var ThroughSubmitData_1 = require("../data/custom/throughSubmit/ThroughSubmitData");
var BeforSubmitData_1 = require("../data/custom/beforSubmit/BeforSubmitData");
var PetAdopteData_1 = require("../data/pet/PetAdopteData");
var PetFeedData_1 = require("../data/pet/PetFeedData");
var PetStatusData_1 = require("../data/pet/PetStatusData");
var SignInfoData_1 = require("../data/pet/SignInfoData");
var PetHomeInfoData_1 = require("../data/pet/PetHomeInfoData");
var GetToysData_1 = require("../data/pet/GetToysData");
var ToyExchangeData_1 = require("../data/pet/ToyExchangeData");
var ToyUseData_1 = require("../data/pet/ToyUseData");
var CollectData_1 = require("../data/pet/CollectData");
var Data_1 = require("../data/Data");
var GetPlugOrderStatusData_1 = require("../data/plug/doJoinPlugDraw/GetPlugOrderStatusData");
var OptionInfoData_1 = require("../data/plug/optionInfo/OptionInfoData");
var UnblockingData_1 = require("../data/plug/unblocking/UnblockingData");
var GetPrizeInfoData_1 = require("../data/plug/getPrizeInfo/GetPrizeInfoData");
// import { ABDataManager } from 'duiba-tc';
var PetIndexData_1 = require("../data/pet/PetIndexData");
var GetRankListData_1 = require("../data/pet/GetRankListData");
var GetFoodPilesData_1 = require("../data/pet/GetFoodPilesData");
var GetRecordData_1 = require("../data/common/GetRecordData");
var UseToyData_1 = require("../data/pets/UseToyData");
var GetActToysListData_1 = require("../data/pets/GetActToysListData");
var ToyExchangesData_1 = require("../data/pets/ToyExchangesData");
var GetUserToysListData_1 = require("../data/pets/GetUserToysListData");
var GetHomeInfoData_1 = require("../data/pets/GetHomeInfoData");
var PetsIndexData_1 = require("../data/pets/PetsIndexData");
var VisitStatisticsData_1 = require("../data/pets/VisitStatisticsData");
var VisitDetailData_1 = require("../data/pets/VisitDetailData");
var ABDataManager_1 = require("../../tc/manager/ABDataManager");
/**
 *Created by cuiliqiang on 2018/3/8
 * 数据管理
 */
var DataManager = (function (_super) {
    __extends(DataManager, _super);
    function DataManager() {
        var _this = _super.call(this) || this;
        /**
         * 签到业务
         */
        _this.petIndexData = new PetIndexData_1.PetIndexData(); //用户基础数据
        /**
         * 外来宠物养成
         */
        _this.petsIndexData = new PetsIndexData_1.PetsIndexData(); //外来宠物活动主页
        _this._getActToysListData = []; //商店道具接口
        /**
         * 插件信息列表
         */
        _this._getPrizeInfoList = {};
        if (_this.isInit) {
            throw Error(TwLang_1.TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(DataManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new DataManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 更新数据
     * @param {NetName} name
     * @param result
     * @returns {any}
     */
    // tslint:disable-next-line:cyclomatic-complexity
    DataManager.prototype.updateData = function (name, result, param) {
        var data;
        switch (name) {
            case NetName_1.NetName.GET_ROLE:
                if (!this._getRoleData) {
                    this._getRoleData = new GetRoleData_1.GetRoleData();
                }
                this._getRoleData.update(result);
                data = this._getRoleData;
                break;
            case NetName_1.NetName.GAME_TOTAL_SCORE:
                if (!this._getUserTotalScoreData) {
                    this._getUserTotalScoreData = new GetUserTotalScoreData_1.GetUserTotalScoreData();
                }
                this._getUserTotalScoreData.update(result);
                data = this._getUserTotalScoreData;
                break;
            case NetName_1.NetName.GET_CREDITS:
                if (!this._getCreditsData) {
                    this._getCreditsData = new GetCreditsData_1.GetCreditsData();
                }
                this._getCreditsData.update(result);
                data = this._getCreditsData;
                break;
            case NetName_1.NetName.GAME_INFO:
                if (!this._getInfoData) {
                    this._getInfoData = new GetInfoData_1.GetInfoData();
                }
                this._getInfoData.update(result);
                data = this._getInfoData;
                break;
            case NetName_1.NetName.GAME_SUMMERINFO:
                if (!this._getSummerInfoData) {
                    this._getSummerInfoData = new GetSummerInfoData_1.GetSummerInfoData();
                }
                this._getSummerInfoData.update(result);
                data = this._getSummerInfoData;
                break;
            case NetName_1.NetName.GAME_START:
                if (!this._doStartData) {
                    this._doStartData = new DoStartData_1.DoStartData();
                }
                this._doStartData.update(result);
                data = this._doStartData;
                break;
            case NetName_1.NetName.GAME_START_STATUS:
                if (!this._getStartStatusData) {
                    this._getStartStatusData = new GetStartStatusData_1.GetStartStatusData();
                }
                this._getStartStatusData.update(result);
                data = this._getStartStatusData;
                break;
            case NetName_1.NetName.GAME_REVIVE:
                if (!this._doReviveData) {
                    this._doReviveData = new DoReviveData_1.DoReviveData();
                }
                this._doReviveData.update(result);
                data = this._doReviveData;
                break;
            case NetName_1.NetName.GAME_REVIVE_STATUS:
                if (!this._getReviveCardNumData) {
                    this._getReviveCardNumData = new GetReviveCardNumData_1.GetReviveCardNumData();
                }
                this._getReviveCardNumData.update(result);
                data = this._getReviveCardNumData;
                break;
            case NetName_1.NetName.GAME_SUBMIT:
                if (!this._gameSubmitData) {
                    this._gameSubmitData = new GameSubmitData_1.GameSubmitData();
                }
                this._gameSubmitData.update(result);
                data = this._gameSubmitData;
                if (result.data) {
                    this._getInfoData.update(result);
                }
                break;
            case NetName_1.NetName.GAME_SUBMIT_STATUS:
                if (!this._gameGetSubmitResultData) {
                    this._gameGetSubmitResultData = new GameGetSubmitResultData_1.GameGetSubmitResultData();
                }
                this._gameGetSubmitResultData.update(result);
                data = this._gameGetSubmitResultData;
                break;
            case NetName_1.NetName.GAME_RANKS:
                if (!this._winRanksData) {
                    this._winRanksData = new WinRanksData_1.WinRanksData();
                }
                this._winRanksData.update(result);
                data = this._winRanksData;
                break;
            case NetName_1.NetName.GAME_OPTIONS:
                if (!this._getOptionsData) {
                    this._getOptionsData = new GetOptionsData_1.GetOptionsData();
                }
                this._getOptionsData.update(result);
                data = this._getOptionsData;
                break;
            case NetName_1.NetName.GAME_RULE:
                if (!this._getRuleData) {
                    this._getRuleData = new GetRuleData_1.GetRuleData();
                }
                this._getRuleData.update(result);
                data = this._getRuleData;
                break;
            case NetName_1.NetName.ADD_TIMES:
                if (!this._addTimesForActivityData) {
                    this._addTimesForActivityData = new AddTimesForActivityData_1.AddTimesForActivityData();
                }
                this._addTimesForActivityData.update(result);
                data = this._addTimesForActivityData;
                break;
            case NetName_1.NetName.COLLECT_RULE:
                if (!this._getCollectRuleData) {
                    this._getCollectRuleData = new GetCollectRuleData_1.GetCollectRuleData();
                }
                this._getCollectRuleData.update(result);
                data = this._getCollectRuleData;
                break;
            case NetName_1.NetName.OPEN_COLLECT:
                if (!this._openCollectGoodsPrizeData) {
                    this._openCollectGoodsPrizeData = new openCollectGoodsPrizeData_1.OpenCollectGoodsPrizeData();
                }
                this._openCollectGoodsPrizeData.update(result);
                data = this._openCollectGoodsPrizeData;
                break;
            case NetName_1.NetName.GAME_REAL_TIME_RANK:
                if (!this._realTimeRankData) {
                    this._realTimeRankData = new RealTimeRankData_1.RealTimeRankData();
                }
                this._realTimeRankData.update(result);
                data = this._realTimeRankData;
                break;
            case NetName_1.NetName.PLUG_DO_JOIN:
                if (!this._doJoinPlugDrawData) {
                    this._doJoinPlugDrawData = new DoJoinPlugDrawData_1.DoJoinPlugDrawData();
                }
                this._doJoinPlugDrawData.update(result);
                data = this._doJoinPlugDrawData;
                break;
            case NetName_1.NetName.PLUG_ORDER_STATUS:
                if (!this._getPlugOrderStatusData) {
                    this._getPlugOrderStatusData = new GetPlugOrderStatusData_1.GetPlugOrderStatusData();
                }
                this._getPlugOrderStatusData.update(result);
                data = this._getPlugOrderStatusData;
                break;
            case NetName_1.NetName.PLUG_PRIZE_INFO://查询插件信息
                var plugID = param.activityId;
                if (!this._getPrizeInfoList[plugID]) {
                    this._getPrizeInfoList[plugID] = new GetPrizeInfoData_1.GetPrizeInfoData();
                }
                this._getPrizeInfoList[plugID].update(result);
                data = this._getPrizeInfoList[plugID];
                break;
            case NetName_1.NetName.SET_ROLE:
                if (!this._setRoleData) {
                    this._setRoleData = new SetRoleData_1.SetRoleData();
                }
                this._setRoleData.update(result);
                data = this._setRoleData;
                break;
            case NetName_1.NetName.CUSTOM_ELEMENT:
                if (!this._ajaxElementData) {
                    this._ajaxElementData = new AjaxElementData_1.AjaxElementData();
                }
                this._ajaxElementData.update(result);
                data = this._ajaxElementData;
                break;
            case NetName_1.NetName.CUSTOM_THROUGH_INFO:
                if (!this._ajaxThroughInfoData) {
                    this._ajaxThroughInfoData = new AjaxThroughInfoData_1.AjaxThroughInfoData();
                }
                this._ajaxThroughInfoData.update(result);
                data = this._ajaxThroughInfoData;
                break;
            case NetName_1.NetName.CUSTOM_DO_JOIN:
                if (!this._doJoinData) {
                    this._doJoinData = new DoJoinData_1.DoJoinData();
                }
                this._doJoinData.update(result);
                data = this._doJoinData;
                break;
            case NetName_1.NetName.CUSTOM_ORDER_STATUS:
                if (!this._getCustomOrderStatusData) {
                    this._getCustomOrderStatusData = new GetCustomOrderStatusData_1.GetCustomOrderStatusData();
                }
                this._getCustomOrderStatusData.update(result);
                data = this._getCustomOrderStatusData;
                this._ajaxElementData.element = result.element;
                break;
            case NetName_1.NetName.CUSTOM_ORDER_INFO:
                if (!this._getOrderInfoData) {
                    this._getOrderInfoData = new GetOrderInfoData_1.GetOrderInfoData();
                }
                this._getOrderInfoData.update(result);
                data = this._getOrderInfoData;
                break;
            case NetName_1.NetName.CUSTOM_THROUGH_SUBMIT:
                if (!this._throughSubmitData) {
                    this._throughSubmitData = new ThroughSubmitData_1.ThroughSubmitData();
                }
                this._throughSubmitData.update(result);
                data = this._throughSubmitData;
                break;
            case NetName_1.NetName.CUSTOM_BEFOR_SUBMIT:
                if (!this._beforSubmitData) {
                    this._beforSubmitData = new BeforSubmitData_1.BeforSubmitData();
                }
                this._beforSubmitData.update(result);
                data = this._beforSubmitData;
                break;
            case NetName_1.NetName.CUSTOM_QUESTION_SUBMIT:
                if (!this._questionSubmitData) {
                    this._questionSubmitData = new QuestionSubmitData_1.QuestionSubmitData();
                }
                this._questionSubmitData.update(result);
                data = this._questionSubmitData;
                break;
            case NetName_1.NetName.GAME_GUESS_POKER:
                if (!this._guessPokerData) {
                    this._guessPokerData = new GuessPokerData_1.GuessPokerData();
                }
                this._guessPokerData.update(result);
                data = this._guessPokerData;
                break;
            case NetName_1.NetName.PLUG_OPTION_INFO:
                if (!this._optionInfoData) {
                    this._optionInfoData = new OptionInfoData_1.OptionInfoData();
                }
                this._optionInfoData.update(result);
                data = this._optionInfoData;
                break;
            case NetName_1.NetName.PET_ADOPTE:
                if (!this._petAdopteData) {
                    this._petAdopteData = new PetAdopteData_1.PetAdopteData();
                }
                this._petAdopteData.update(result);
                this.petIndexData.update(result.data); //更新petIndexData里面的活动id(activityid);
                if (!this._petHomeInfoData) {
                    this._petHomeInfoData = new PetHomeInfoData_1.PetHomeInfoData();
                }
                this._petHomeInfoData.update(result); //更新宠物信息
                data = this._petAdopteData;
                break;
            case NetName_1.NetName.PET_FEED:
                if (!this._petFeedData) {
                    this._petFeedData = new PetFeedData_1.PetFeedData();
                }
                this._petFeedData.update(result);
                if (!this._petHomeInfoData) {
                    this._petHomeInfoData = new PetHomeInfoData_1.PetHomeInfoData();
                }
                this._petHomeInfoData.update(result); //更新宠物信息
                data = this._petFeedData;
                break;
            case NetName_1.NetName.PET_STATUS:
                if (!this._petStatusData) {
                    this._petStatusData = new PetStatusData_1.PetStatusData();
                }
                this._petStatusData.update(result);
                if (!this._petHomeInfoData) {
                    this._petHomeInfoData = new PetHomeInfoData_1.PetHomeInfoData();
                }
                this._petHomeInfoData.update(result); //更新宠物信息
                data = this._petStatusData;
                break;
            case NetName_1.NetName.PET_INFO:
                if (!this._petHomeInfoData) {
                    this._petHomeInfoData = new PetHomeInfoData_1.PetHomeInfoData();
                }
                this._petHomeInfoData.update(result); //更新宠物信息
                data = this._petHomeInfoData;
                break;
            case NetName_1.NetName.PET_TOYS://签到养成里暂时没用到这个接口
                if (!this._getToysData) {
                    this._getToysData = new GetToysData_1.GetToysData();
                }
                this._getToysData.update(result);
                data = this._getToysData;
                break;
            case NetName_1.NetName.PET_TOY_EXCHANGE://签到养成里暂时没用到这个接口
                if (!this._toyExchangeData) {
                    this._toyExchangeData = new ToyExchangeData_1.ToyExchangeData();
                }
                this._toyExchangeData.update(result);
                data = this._toyExchangeData;
                break;
            case NetName_1.NetName.PET_TOY_USE://签到养成里暂时没用到这个接口
                if (!this._toyUseData) {
                    this._toyUseData = new ToyUseData_1.ToyUseData();
                }
                this._toyUseData.update(result);
                data = this._toyUseData;
                break;
            case NetName_1.NetName.PET_COLLECT://收取礼物接口
                if (!this._collectData) {
                    this._collectData = new CollectData_1.CollectData();
                }
                this._collectData.update(result);
                data = this._collectData;
                break;
            case NetName_1.NetName.SIGN_INFO: //查询签到信息接口
            case NetName_1.NetName.SIGN_DO_SIGN://签到接口
                if (!this._signInfoData) {
                    this._signInfoData = new SignInfoData_1.SignInfoData();
                }
                this._signInfoData.update(result);
                data = this._signInfoData;
                break;
            case NetName_1.NetName.PET_GET_RANK_LIST://群内喂食排行榜
                if (!this._getRankListData) {
                    this._getRankListData = new GetRankListData_1.GetRankListData();
                }
                this._getRankListData.update(result);
                data = this._getRankListData;
                break;
            case NetName_1.NetName.PET_GET_FOOD_PILES://查询待领取粮食
                if (!this._getFoodPilesData) {
                    this._getFoodPilesData = new GetFoodPilesData_1.GetFoodPilesData();
                }
                this._getFoodPilesData.update(result);
                data = this._getFoodPilesData;
                break;
            case NetName_1.NetName.PET_COLLECT_FOOD://待领取粮食收取
                if (!data) {
                    data = new Data_1.Data();
                }
                data.update(result);
                break;
            case NetName_1.NetName.PETS_GET_HOME_INFO://外来宠物养成---活动主信息接口
                if (!this._getHomeInfoData) {
                    this._getHomeInfoData = new GetHomeInfoData_1.GetHomeInfoData();
                }
                this._getHomeInfoData.update(result);
                data = this._getHomeInfoData;
                break;
            case NetName_1.NetName.PETS_GET_ACT_TOYS://外来宠物养成---商店道具接口
                var toyType = param.toyType;
                if (!this._getActToysListData[toyType]) {
                    this._getActToysListData[toyType] = new GetActToysListData_1.GetActToysListData();
                }
                this._getActToysListData[toyType].update(result);
                data = this._getActToysListData[toyType];
                break;
            case NetName_1.NetName.PETS_TOY_EXCHANGE://外来宠物养成---道具兑换
                if (!this._toyExchangesData) {
                    this._toyExchangesData = new ToyExchangesData_1.ToyExchangesData();
                }
                this._toyExchangesData.update(result);
                data = this._toyExchangesData;
                break;
            case NetName_1.NetName.PETS_USE_TOYS://外来宠物养成---道具使用
                if (!this._useToyData) {
                    this._useToyData = new UseToyData_1.UseToyData();
                }
                this._useToyData.update(result);
                data = this._useToyData;
                break;
            case NetName_1.NetName.PETS_GET_USER_TOYS://外来宠物养成---已购买的道具
                if (!this._getUserToysListData) {
                    this._getUserToysListData = new GetUserToysListData_1.GetUserToysListData();
                }
                this._getUserToysListData.update(result);
                data = this._getUserToysListData;
                break;
            case NetName_1.NetName.PETS_BATCHOLLECT_FOOD://外来宠物养成---收取猫草
                if (!this._batchollectFoodData) {
                    this._batchollectFoodData = new Data_1.Data();
                }
                this._batchollectFoodData.update(result);
                data = this._batchollectFoodData;
                break;
            case NetName_1.NetName.PETS_VISI_STATISTICS://外来宠物养成---来访统计
                if (!this._visitStatisticsData) {
                    this._visitStatisticsData = new VisitStatisticsData_1.VisitStatisticsData();
                }
                this._visitStatisticsData.update(result);
                data = this._visitStatisticsData;
                break;
            case NetName_1.NetName.PETS_GET_VISIT_INFO://未来宠物养成---动态信息列表
                if (!this._getVisitInfoData) {
                    this._getVisitInfoData = new GetVisitInfoData_1.GetVisitInfoData();
                }
                this._getVisitInfoData.update(result);
                data = this._getVisitInfoData;
                break;
            case NetName_1.NetName.PETS_VISIT_DETAIL://外来宠物养成---到访记录详情
                if (!this._visitDetailData) {
                    this._visitDetailData = new VisitDetailData_1.VisitDetailData();
                }
                this._visitDetailData.update(result);
                data = this._visitDetailData;
                break;
            case NetName_1.NetName.PETS_COLLECT_GIFT_RECORD:
                if (!this._collectGiftRecord) {
                    this._collectGiftRecord = new Data_1.Data();
                }
                this._collectGiftRecord.update(result);
                data = this._collectGiftRecord;
                break;
            case NetName_1.NetName.PLUG_UNBLOCKING:
                if (!this._unblockingData) {
                    this._unblockingData = new UnblockingData_1.UnblockingData();
                }
                this._unblockingData.update(result);
                data = this._unblockingData;
                break;
            case NetName_1.NetName.GAME_DATA_PASH:
                if (!this._datapashData) {
                    this._datapashData = new DatapashData_1.DatapashData();
                }
                this._datapashData.update(result);
                data = this._datapashData;
                break;
            case NetName_1.NetName.GAME_SUMMER_BUYPROP:
                this._summerBuyPropData = result;
                data = result;
                break;
            case NetName_1.NetName.GAME_SUMMER_GET_ORDER_STATUS:
                this._summerOrderStatus = result;
                data = result;
                break;
            case NetName_1.NetName.GAME_SUMMER_GET_TOY_INFO:
                this._summerToyInfo = result;
                data = result;
                break;
            case NetName_1.NetName.GET_RECORD://查询我的奖品记录
                if (!this._getRecordData) {
                    this._getRecordData = new GetRecordData_1.GetRecordData();
                }
                this._getRecordData.update(result);
                data = this._getRecordData;
            default:
                this[this.getKey(name)] = result;
        }
        this.dispatchEvent(new egret.Event('dataUpdate', false, false, name));
        return data || result;
    };
    DataManager.prototype.getData = function (name) {
        return this[this.getKey(name)];
    };
    DataManager.prototype.getKey = function (name) {
        return "_tw_data_" + name + "_";
    };
    Object.defineProperty(DataManager.prototype, "getInfoData", {
        /**
         * 用户信息
         */
        get: function () {
            return this._getInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getSummerInfoData", {
        /**
         * 夏日活动用户信息
         */
        get: function () {
            return this._getSummerInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRoleData", {
        /**
         * 角色信息
         */
        get: function () {
            return this._getRoleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getUserTotalScoreData", {
        /**
         * 用户成长值
         */
        get: function () {
            return this._getUserTotalScoreData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCreditsData", {
        /**
         * 用户积分
         */
        get: function () {
            return this._getCreditsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doStartData", {
        /**
         * 开始游戏
         */
        get: function () {
            return this._doStartData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getStartStatusData", {
        /**
         * 开始游戏订单结果
         */
        get: function () {
            return this._getStartStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doReviveData", {
        /**
         * 复活
         */
        get: function () {
            return this._doReviveData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getReviveCardNumData", {
        /**
         * 获得复活卡数量
         */
        get: function () {
            return this._getReviveCardNumData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gameSubmitData", {
        /**
         * 游戏提交
         */
        get: function () {
            return this._gameSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gameGetSubmitResultData", {
        /**
         * 游戏提交订单结果
         */
        get: function () {
            return this._gameGetSubmitResultData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "winRanksData", {
        /**
         * 开奖
         */
        get: function () {
            return this._winRanksData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getOptionsData", {
        /**
         * 游戏奖品
         */
        get: function () {
            return this._getOptionsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRuleData", {
        /**
         * 游戏规则
         */
        get: function () {
            return this._getRuleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "addTimesForActivityData", {
        /**
         * 活动次数
         */
        get: function () {
            return this._addTimesForActivityData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCollectRuleData", {
        /**
         * 集卡规则
         */
        get: function () {
            return this._getCollectRuleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "openCollectGoodsPrizeData", {
        /**
         * 集卡开奖
         */
        get: function () {
            return this._openCollectGoodsPrizeData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "realTimeRankData", {
        /**
         * 实时排行榜
         */
        get: function () {
            return this._realTimeRankData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doJoinPlugDrawData", {
        /**
         * 插件
         */
        get: function () {
            return this._doJoinPlugDrawData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getPlugOrderStatusData", {
        /**
         * 插件订单结果
         */
        get: function () {
            return this._getPlugOrderStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "setRoleData", {
        /**
         * 设置角色
         */
        get: function () {
            return this._setRoleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "ajaxElementData", {
        /**
         * 活动工具基础信息
         */
        get: function () {
            return this._ajaxElementData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "ajaxThroughInfoData", {
        /**
         * 闯关游戏基础信息
         */
        get: function () {
            return this._ajaxThroughInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doJoinData", {
        /**
         * 活动工具抽奖
         */
        get: function () {
            return this._doJoinData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCustomOrderStatusData", {
        /**
         * 活动工具订单结果
         */
        get: function () {
            return this._getCustomOrderStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getOrderInfoData", {
        /**
         * 前置抽奖
         */
        get: function () {
            return this._getOrderInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "throughSubmitData", {
        /**
         * 闯关游戏提交
         */
        get: function () {
            return this._throughSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "beforSubmitData", {
        /**
         * 前置开奖提交
         */
        get: function () {
            return this._beforSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "questionSubmitData", {
        /**
         * 答题提交
         */
        get: function () {
            return this._questionSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "guessPokerData", {
        /**
         * 猜扑克
         */
        get: function () {
            return this._guessPokerData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "optionInfoData", {
        /**
         * 插件奖品信息
         */
        get: function () {
            return this._optionInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "unblockingData", {
        /**
         * 解锁插件
         */
        get: function () {
            return this._unblockingData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "datapashData", {
        /**
         * 防作弊阶段提交
         */
        get: function () {
            return this._datapashData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerBuyPropData", {
        get: function () {
            return this._summerBuyPropData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerOrderStatus", {
        get: function () {
            return this._summerOrderStatus;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerToyInfo", {
        get: function () {
            return this._summerToyInfo;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petHomeInfoData", {
        /**
         * 养成
         * 宠物基础数据
         */
        get: function () {
            return this._petHomeInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petFeedData", {
        /**
         * 养成
         * 宠物喂食回调数据
         */
        get: function () {
            return this._petFeedData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "signInfoData", {
        /**
         * 养成
         * 签到信息
         */
        get: function () {
            return this._signInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getPrizeInfoList", {
        /**
         * 插件列表
         */
        get: function () {
            return this._getPrizeInfoList;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRankListData", {
        /**
         * 喂养排名信息
         */
        get: function () {
            return this._getRankListData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getFoodPilesData", {
        /**
         * 查询待领取粮食信息
         */
        get: function () {
            return this._getFoodPilesData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRecordData", {
        /**
         * 查询我的奖品记录
         */
        get: function () {
            return this._getRecordData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getHomeInfoData", {
        /**
         * 外来宠物养成--活动主信息接口
         */
        get: function () {
            return this._getHomeInfoData;
        },
        set: function (d) {
            this._getHomeInfoData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gtBatchollectFoodData", {
        /**
         * 收取猫草回调数据
         */
        get: function () {
            return this._batchollectFoodData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getActToysListData", {
        /**
         * 外来宠物养成--商店道具接口
         */
        get: function () {
            return this._getActToysListData;
        },
        set: function (d) {
            this._getActToysListData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getUserToysListData", {
        /**
         * 外来宠物养成--商店道具接口
         */
        get: function () {
            return this._getUserToysListData;
        },
        set: function (d) {
            this._getUserToysListData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "visitStatisticsData", {
        /**
         * 外来宠物养成--来访统计
         */
        get: function () {
            return this._visitStatisticsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getVisitInfoData", {
        /**
         * 外来宠物养成--动态信息列表
         */
        get: function () {
            return this._getVisitInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "visitDetailData", {
        /**
         * 外来宠物养成--到访记录详情
         */
        get: function () {
            return this._visitDetailData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "collectGiftRecord", {
        /**
         * 外来宠物养成--礼物收取
         */
        get: function () {
            return this._collectGiftRecord;
        },
        enumerable: true,
        configurable: true
    });
    return DataManager;
}(ABDataManager_1.ABDataManager));
exports.DataManager = DataManager;
__reflect(DataManager.prototype, "\"e:/zqty/egret/libs/tw/manager/DataManager\".DataManager");
//# sourceMappingURL=DataManager.js.map