"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("../../tw/manager/NetManager");
var DataManager_1 = require("../../tw/manager/DataManager");
/**
 * 提交游戏成绩
 * @param callback
 * @param score 得分
 * @param checkScore  是否校验得分
 * @param customizedType 定制类型 1推币机
 */
var submit = function (callback, score, checkScore, customizedType) {
    var allDynamics = [];
    gameSubmitData(callback, score, allDynamics, checkScore, customizedType);
};
/**
* 提交游戏成绩
* @param callback
* @param score 得分
* @param allDynamics 防作弊数据
* @param checkScore  是否校验得分
* @param customizedType 定制类型 1推币机
*/
var gameSubmitData = function (callback, score, allDynamics, checkScore, customizedType) {
    NetManager_1.NetManager.ins.gameSubmit(function (success) {
        if (success) {
            getSubmitResult(callback, DataManager_1.DataManager.ins.gameSubmitData.orderId);
        }
        else {
            callback(success);
        }
    }, DataManager_1.DataManager.ins.doStartData.ticketId, score, '[]', DataManager_1.DataManager.ins.doStartData.submitToken, JSON.stringify(allDynamics), checkScore, customizedType);
};
/**
 * 查询提交结果
 * @param callback
 * @param orderId
 */
var getSubmitResult = function (callback, orderId) {
    NetManager_1.NetManager.ins.getSubmitResult(callback, orderId, function () {
        return DataManager_1.DataManager.ins.gameGetSubmitResultData.flag;
    });
};
exports.default = submit;
//# sourceMappingURL=submit.js.map