import { DataManager } from "../../../libs/tw/manager/DataManager";

export default class Tips extends eui.Label {
    constructor() {
        super();
        this.horizontalCenter = "0";
        this.width = 750;
        this.textAlign = "center";
        this.size = 22;

        this.updateText();
        DataManager.ins.addEventListener('dataUpdate', this.updateText, this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onAddToStage, this);
    }

    onAddToStage() {
        this.y = 1142;
        if (this.stage.stageHeight > 1300)
            this.y = 1206;
        if (this.stage.stageHeight < 1206)
            this.y = this.stage.stageHeight - this.textHeight - 40;
    }

    updateText() {
        if (!DataManager.ins.getInfoData) return;
        this.text = DataManager.ins.getInfoData.status.text;
    }
}