## 安装和更新构建工具
重新拉取代码，然后安装依赖。
``` bash
git pull && cnpm install
```

## 启动本地服务器
``` bash
npm run dev
```
之后会自动打开浏览器。建议在vscode中f5调试，效率更高。

## 发布
### 全发布
```bash
npm run build 
```
### 仅仅发布src下的TS代码
``` bash
npm run buildTS
```
之后只需要更新皮肤中的`output.js`文件的版本号
```js
<script crossorigin="anonymous" src="//yun.duiba.com.cn/db_games/activity/demo/1537173012/output.js"></script>
```
### 仅仅发布exmls文件
``` bash
npm run buildExml 
```
之后只需要更新皮肤中的`default.thm.js`文件的版本号
```js
<script crossorigin="anonymous" src="//yun.duiba.com.cn/db_games/activity/demo/1537172754/resource/default.thm.js"></script>
```

## demo
- demo皮肤 https://mng.duiba.com.cn/DuibaNgameBrick/edit/476
- demo线上url http://activity-2.m.duiba.com.cn/ngame/index?id=3122353&dbnewopen&dpm=1.5.677.4&dcm=202.3122353.4.677

## 备注


项目创建和维护流程

1.先建立一个分支

git checkout -b kickball-20180910


2.然后duiba-games下直接创建【项目名称】的文件夹kickball-20180910


3.push分支到远程

git push --set-upstream origin kickball-20180910


4.然后在分支下开发，如果是新类型游戏，将来可能需要换皮的，那么备份到backup下。移动 kickball-20180910到backup。


5.然后合并到主分支。

git checkout dev

git merge kickball-20180910

git push


6、因为已经backup，所以这个分支已经没用了，删除分支

git branch -D kickball-20180910

git push origin :kickball-20180910

如果不需backup后面要维护，那么留着分支，不必合并到主分支。这样可以避免频繁提交导致的频繁git pull，提升效率。


发布到线上

全发布 ：npm run build  [项目名称]  。比如npm run build kickball-egret

仅仅发布src下的TS代码：npm run buildTS  [项目名称] 。比如npm run buildTS kickball-egret

仅仅发布exmls文件：npm run buildExml  [项目名称] 。比如npm run buildExml kickball-egret。

自动化图集合并说明

不会合并组内的jpg。一般jpg都是外部加载，合入png图集，会显著增加png图集的体积