import { Data } from './../../Data';
import { ICollectRuleData } from './ICollectRuleData';

/**
 *Created by cuiliqiang on 2018/3/7
 * 集卡数据
 */
export class GetCollectRuleData extends Data {
    /**
     * 集卡规则列表
     */
    public collectRules: ICollectRuleData[];

    /**
     * 奖品等级（几等奖）
     */
    public prizeLevel: number;

    /**
     * 是否可以开奖
     */
    public clickFlag: boolean;

    /**
     * 
     */
    public exchange: boolean;

    /**
     * 所有卡片数量
     */
    public allCount: number;

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.prizeLevel = data.prizeLeve;
        this.clickFlag = data.clickFlag;
        this.exchange = data.exchange;
        this.collectRules = data.collectRule;
        
        if (data.collectGoods) {
            const len = data.collectGoods.length;
            let i = 0;
            for (i; i < len; i++) {
                this.allCount += data.collectGoods[i].count;
            }
        } else {
            this.allCount = 0;
        }
    }
}