import { NetManager } from "../../../libs/tw/manager/NetManager";
import { DataManager } from "../../../libs/tw/manager/DataManager";

/**
 * 开始游戏
 * @param callback 
 * @param isAgain
 * @param credits 
 * @param customizedType 
 */
const doStart = (callback: Function, isAgain = false, credits?: number, customizedType?: number) => {
    if (window['requirelogin'] && window['config_notrequirelogin'] === undefined) {
        window['requirelogin']();
        return;
    }
    NetManager.ins.doStart((success: boolean) => {
        if (success) {
            getStartOrderStatus(callback, customizedType);
        } else {
            callback(success);
        }
    },
        isAgain,
        credits,
        customizedType);
}

/**
 * 查询订单结果
 * @param callback 
 * @param ticketId 
 * @param customizedType
 */
const getStartOrderStatus = (callback: Function, customizedType?: number) => {
    NetManager.ins.getStartStatus(
        callback,
        DataManager.ins.doStartData.ticketId,
        () => { return DataManager.ins.getStartStatusData.code != 1; },
        5,
        customizedType);
}
export default doStart;