import {showToast} from "../../comm/UtilsConst";

export enum CROP_TYPE {
    NONE = 0,  // 啥也没有
    CHICKEN = 1,    // 鸡
    WHEAT = 2,      // 牛
    CORN = 3,       // 玉米
    CATTLE = 4,     // 牛
    POTATO = 5,     // 土豆
    WALNUT = 6,     // 核桃
    APPLE = 7,//苹果
    PAPAYA=8,//木瓜
}

export let petData = {
    [CROP_TYPE.NONE]: {    // 啥也没有
        key: '',
        name: '',
        type: '',
        pos: [],
        propId: '',
        optionSvga: '',
        option: '',
        catherImg: '',
        introduce: '',
    },
    [CROP_TYPE.CHICKEN]: {    // 鸡
        key: 'chicken',
        name: '鸡',
        type: 'animal',
        pos: [-13, -162],
        propId: 'sp_food_1',
        optionSvga: 'ready_feed',
        option: 'feed',
        catherImg: '鸡蛋',
        introduce: '24小时即可长成,每八小时喂食一次\n长成后预计可得4个鸡蛋',
    },
    [CROP_TYPE.WHEAT]: {    // 水稻
        key: 'wheat',
        name: '大米',
        type: 'plant',
        pos: [-25, -135],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '麦粉',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋大米',
    },
    [CROP_TYPE.CORN]: {    // 玉米
        key: 'corn',
        name: '玉米',
        type: 'plant',
        pos: [-30, -140],
        catherPos: [-30, -180],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '玉米',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋玉米',
    },
    [CROP_TYPE.CATTLE]: {    // 牛
        key: 'cattle',
        name: '牛',
        type: 'animal',
        pos: [-30, -140],
        prop: 'food',
        propId: 'sp_food_1',
        optionSvga: 'ready_feed',
        option: 'feed',
        catherImg: '牛奶',
        introduce: '24小时即可长成,每八小时喂食一次\n长成后预计可得4瓶牛奶',
    },
    [CROP_TYPE.POTATO]: {    // 土豆
        key: 'potato',
        name: '土豆',
        type: 'plant',
        pos: [-32, -140],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '土豆',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋土豆',
    },
    [CROP_TYPE.WALNUT]: {    // 核桃
        key: 'walnut',
        name: '核桃',
        type: 'plant',
        pos: [-32, -135],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '核桃',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋核桃',
    },
    [CROP_TYPE.APPLE]: {    // 苹果
        key: 'apple',
        name: '苹果',
        type: 'plant',
        pos: [-32, -155],
        pos1:[-32,-155],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '苹果',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋苹果',
    },
    [CROP_TYPE.PAPAYA]: {    // 木瓜
        key: 'papaya',
        name: '木瓜',
        type: 'plant',
        pos: [-30, -175],
        pos1:[-32,-145],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '木瓜',
        introduce: '16小时即可长成,每八小时浇水一次\n长成后预计可得4袋木瓜',
    },
};

export function getToken() {
    console.log('尝试获取token');
    return new Promise((s, j) => {
        if (window.location.port == '8080') {
            s('dev-token');
        } else {
            if (window['getPxToken']) {
                window['getPxToken'](function (e, token) {
                    switch (e) {
                        case 'net error':
                            showToast(`getToken: ${e}`);
                            s(null);
                            break;
                        case 'need login':
                            showToast(`getToken: ${e}`);
                            s(null);
                            break;
                        case 'state invalid':
                            showToast(`getToken: ${e}`);
                            s(null);
                            break;
                        default:
                            if (token) {
                                s(token);
                            } else {
                                showToast(`getToken: invalid key`);
                                s(null);
                            }
                            break;
                    }
                });
            } else {
                showToast(`getToken: no ready`);
                s(null);
            }
        }
    })
}


/**
 * 检查菱形包围盒
 * @param x 点击点x
 * @param y 点击点y
 * @param w 菱形宽度
 * @param h 菱形高度
 */
export function detectionDiamond(x: number, y: number, w: number, h: number): boolean {
    return Math.abs((x - w / 2) * h / 2) + Math.abs((y - h / 2) * w / 2) <= w * h / 4;
}

let el: HTMLDivElement;

export function htmlToPureText(htmlText) {
    if (!el) {
        el = document.createElement('div');
    }
    el.innerHTML = htmlText;
    document.body.appendChild(el);
    let pureText = el.innerText;
    document.body.removeChild(el);
    return pureText;
}