import Panel from "../views/Panel";
import TouchEvent = egret.TouchEvent;
import {NetManager} from "../../libs/tw/manager/NetManager";
import {wait} from "../comm/GameConst";

export default class OldUserPanel extends Panel {
    public closeBtn: eui.Button;
    public btn: eui.Button;

    public get skinKey() {
        return 'OldUserPanel'
    }

    public get groupName() {
        return 'oldUser_panel'
    }

    constructor(data?) {
        super(data);

    }

    protected start() {
        super.start();
    }

    public initEvents() {
        super.initEvents();
        this.btn.addEventListener(TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    public removeEvents() {
        super.removeEvents();
        this.btn.removeEventListener(TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    async hidePanel() {
        super.hidePanel();

        await wait(500);
        this.data.f();
    }
}
