import { Circle } from "../physics/Circle";
import PlayScene from "../PlayScene";

export default (that: PlayScene, x, y, num) => {
    let block: Circle = that.pool.takeOut("specialCircle");
    const radius = (RES.getRes('+1_png') as egret.Texture).textureWidth / 2;
    const length = radius * 2;
    if (!block) {
        const sprite = new egret.Sprite();
        sprite.touchEnabled = sprite.touchChildren = false;
        //背景
        const shape = new egret.Bitmap(RES.getRes('+1_png'));
        shape.anchorOffsetX = shape.width / 2;
        shape.anchorOffsetY = shape.height / 2;
        sprite["bg"] = shape;
        sprite.addChild(shape);

        block = new Circle(radius, sprite);
        block.type = 'specialCircle';
    } else {
        if (block.radius != radius) {
            block.view.bg.graphics.clear();
            block.view.bg.graphics.beginFill(0xcccccc);
            block.view.bg.graphics.drawCircle(0, 0, radius);
            block.view.bg.graphics.endFill();
        }
    }
    that.addChild(block.view)
    block.x = x;
    block.y = y;
    block.num = num;
    that.blocks.push(block);
}