import { award, awardMask } from "./collisionConfig";
import createItem from "./items/createItem";
import StartScene from "./StartScene";

export default (_this: StartScene) => {
    const startY = 984;
    const startX = 100;
    const forceScale = 7;
    const leftStart = { x: startX, y: startY, forceX: 0.01 * forceScale };
    const rightStart = { x: 750 - startX, y: startY, forceX: -0.01 * forceScale };
    setInterval(() => {
        const start = Math.random() > 0.5 ? leftStart : rightStart;

        const size = 49*1.15;
        const maxsize = 49;
        const baseItem = createItem(size / maxsize);
        let angle;
        angle = 0;
        const fallingCircle = _this._egretRender.circle(start.x, start.y, size / 2, baseItem,
            // _this._egretRender.circle(375 + Math.random() * 200 - 100, 400 + 200 + 100, (size - 17) / 2, baseItem,
            {
                isStatic: false,
                force: { x: start.forceX, y: 0 },
                friction: 0,
                restitution: .7,
                collisionFilter: { group: award, category: award, mask: awardMask }
            }
        );

        // const fallingCircle = Matter.Bodies.circle(start.x, start.y, 10 + Math.random() * 5, {
        //     isStatic: false,
        //     force: { x: start.forceX, y: 0 },
        //     friction: 0,
        //     restitution: 1,
        //     collisionFilter: { group: award, category: award, mask: awardMask }
        // });

        // const fallingRect = Matter.Bodies.rectangle(start.x, start.y, 50, 20, {
        //     isStatic: false,
        //     force: { x: start.forceX, y: 0 },
        //     friction: .5,
        //     restitution: .5,
        //     collisionFilter: { group: award, category: award, mask: awardMask }
        // });

        // (Matter.World.add(_this._engine.world, fallingCircle));
        // Math.random() > 0.2 ? (Matter.World.add(this._engine.world, fallingCircle)) :
        //     (Matter.World.add(this._engine.world, fallingRect));

    }, 1000);
}