import { wall, wallMask, basket, basketMask } from "./collisionConfig";
import StartScene from "./StartScene";

const createBox = (_this: StartScene) => {
    _this._egretRender.rectangle(750 / 2, 1500, 750, 60, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
    _this._egretRender.rectangle(0, 1624 / 2, 60, 1624, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
    _this._egretRender.rectangle(750, 1624 / 2, 60, 1624, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });


    const seesaw = _this._egretRender.rectangle(375, 1174, 503, 70, _this['arrow'], {
        isStatic: true,
        friction: 0,
        collisionFilter: { group: basket, category: basket, mask: basketMask },
    });

    // const basketPath = Matter.Vertices.fromPath('0 0 1 0 10 90 190 90 199 0 200 0 200 100 0 100', null);
    // const basketBody = Matter.Bodies.fromVertices(150, 900 + 500, [basketPath], { isStatic: true, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    // Matter.World.add(_this._engine.world, basketBody);

    // const rightBasketBody = Matter.Bodies.fromVertices(600, 900 + 500, [basketPath], { isStatic: true, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    // Matter.World.add(_this._engine.world, rightBasketBody);

    //钉子约束
    const nailConstraint = Matter.Constraint.create({
        pointA: {
            x: 375,
            y: 1174
        },
        bodyB: seesaw,
        pointB: {
            x: 0,
            y: 0
        },
        stiffness: 1
    })

    Matter.World.add(_this._engine.world, seesaw);
    Matter.World.add(_this._engine.world, nailConstraint);

    return { seesaw: seesaw }
}

export default createBox