import ComponentBase from "../components/ComponentBase";

export default class Panel extends ComponentBase {
    constructor() {
        super();
    }

    initEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
    }
    removeEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }

}