import { DataManager } from './../../../libs/tw/manager/DataManager';
import { NetPromise } from './../../promises/NetPromise';
import { arr } from '../../consts/GameConst';
import { GDispatcher } from '../../../libs/tc/util/GDispatcher';
import { GCache } from '../../../libs/tc/util/GCache';
import Scene from "../../views/Scene";
import SVGACtrl from "../../ctrls/svgaCtrl";
import GameConst from '../../consts/GameConst';
import Ballon from './Ballon';
import PanelCtrl from '../../ctrls/panelCtrl';
import { ModuleTypes } from '../../types/ModuleTypes';
import NetConst from '../../consts/NetConst';
import ToastCtrl from '../../ctrls/toastCtrl';

export default class PlayScene extends Scene {

    get skinKey() { return "Play" }

    public gameLayer: eui.Group;
    public bg: eui.Image;
    public countDownTxt: eui.Label;
    public ssBallon1: eui.Image;
    public ssBallon2: eui.Image;
    public ssBallon3: eui.Image;
    public ssBallon4: eui.Image;
    public rope: eui.Image;
    public pumpBtn: eui.Image;
    public sBallon: eui.Image;
    public sBallonGroup: eui.Group;
    public leftCount: eui.Label;
    public ready: eui.Component;
    public guideLayer: eui.Group;
    public step1: eui.Group;
    public step2: eui.Group;
    public step3: eui.Group;
    public step4: eui.Group;
    public nextBtn: eui.Button;
    public startBtn: eui.Button;
    public skipBtn: eui.Button;



    // 成功打气球次数
    public sucCount = 0;

    public sBallonsArr = []
    public ballonsPool = [];

    public currBallon

    start() {

        this.ballonsPool = ["yellow", "blue", "pink", "red"]
        this.sBallonsArr = ["y", "b", "p", "r"]
    }

    initUI() {
        let turkey = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.getSVGAByName("playTurkey"));
        turkey.x = 400
        turkey.y = 680
        this.gameLayer.addChildAt(turkey, 10)
        this.ballonsPool = ["yellow", "blue", "pink", "red"]
        this.sBallonsArr = ["y", "b", "p", "r"]
        this.initSmallBallons()

        // 没引导过进引导
        if (!GCache.readCache("isGuide" + DataManager.ins.customCfgData.consumerId)) {
            GCache.writeCache("isGuide" + DataManager.ins.customCfgData.consumerId, "1")
            this.initGuide()
        } else {
            this.restartGame()
        }
    }

    sBallonsPool;
    initSmallBallons() {
        // arr.shuffle(this.sBallonsArr);
        this.sBallonsPool = [];
        for (let i = this.sBallonsArr.length - 1; i > 0; i--) {
            let color = this.sBallonsArr[i]
            let sBallon = new eui.Image()
            sBallon.source = "ssBallon_" + color + "_png"
            sBallon.scaleX = 0.9
            sBallon.scaleY = 0.9
            this.sBallonGroup.addChild(sBallon)
            this.sBallonsPool.push(sBallon)
        }

    }

    guideStep = 1
    initGuide() {
        this.guideLayer.visible = true;
        this.guideStep1()
        GDispatcher.addEvent("guideStep2", this.guideStep2, this)
        GDispatcher.addEvent("guideStep3", this.guideStep3, this)
        GDispatcher.addEvent("guideStep4", this.guideStep4, this)

        this.onTap(this.skipBtn, this.onTap_startBtn)
        this.onTap(this.nextBtn, this.onTap_nextBtn)
        this.onTap(this.startBtn, this.onTap_startBtn)

    }

    guideBallon
    guideStep1() {
        let mask = GameConst.drawCircleMask(375, 940, 150)
        this.step1.visible = true;
        this.step1.addChild(mask)

        let tips = new eui.Label()
        tips.text = `连续点击按钮即可为气球打气`
        tips.horizontalCenter = 0;
        tips.y = 700
        this.step1.addChild(tips)

        this.pumpBtn.source = `pumpDownBtn_png`
        this.pumpBtn.y = 825 + 24

        egret.Tween.removeTweens(this.pumpBtn)
        egret.Tween.get(this.pumpBtn, { loop: true })
            .set({ y: 825 + 24 })
            .to({ y: 825 + 22 }, 67)
            .to({ y: 825 + 24 }, 67)

        let finger = new eui.Image()
        finger.source = `finger_png`;
        finger.x = 375 + 15
        finger.y = 940 + 15
        this.step1.addChild(finger)

        egret.Tween.get(finger, { loop: true })
            .to({ scaleX: 0.95, scaleY: 0.95 }, 67)
            .to({ scaleX: 1, scaleY: 1 }, 67)

        this.guideBallon = new Ballon()
        this.guideBallon.anchorOffsetX = 161
        this.guideBallon.anchorOffsetY = 376;
        this.guideBallon.x = 361
        this.guideBallon.y = 802
        this.guideBallon.scaleX = .5
        this.guideBallon.scaleY = .5
        this.gameLayer.addChildAt(this.guideBallon, 5)


        egret.Tween.get(this.guideBallon)
            .to({ scaleX: .7, scaleY: .7 }, 1000)
    }

    guideStep2() {
        let mask = GameConst.drawCircleMask(375, 600, 200)
        this.step1.visible = false;
        this.step2.visible = true;
        this.step2.addChild(mask)

        let tips = new eui.Label()
        tips.text = `当气球在虚线间内松开按钮停止打气，\n则打气成功即可放飞感恩气球`
        tips.textAlign = "center"
        tips.verticalAlign = "center"
        tips.lineSpacing = 15;
        tips.horizontalCenter = 0;
        tips.y = 850
        this.step2.addChild(tips)

        this.pumpBtn.source = `pumpDownBtn_png`
        this.pumpBtn.y = 825 + 24

        egret.Tween.removeTweens(this.pumpBtn)
        egret.Tween.get(this.pumpBtn, { loop: true })
            .set({ y: 825 + 24 })
            .to({ y: 825 + 22 }, 50)
            .to({ y: 825 + 24 }, 50)


        egret.Tween.get(this.guideBallon)
            .to({ scaleX: 1, scaleY: 1 }, 1000)

    }

    guideStep3() {
        let mask = GameConst.drawCircleMask(375, 600, 220)
        this.step2.visible = false;
        this.step3.visible = true;
        this.step3.addChild(mask)

        let tips = new eui.Label()
        tips.text = `当气球大小超过虚线区间范围，\n气球爆破，游戏失败`
        tips.textAlign = "center"
        tips.verticalAlign = "center"
        tips.lineSpacing = 15;
        tips.horizontalCenter = 0;
        tips.y = 850
        this.step3.addChild(tips)

        this.pumpBtn.source = `pumpDownBtn_png`
        this.pumpBtn.y = 825 + 24

        egret.Tween.removeTweens(this.pumpBtn)
        egret.Tween.get(this.pumpBtn, { loop: true })
            .set({ y: 825 + 24 })
            .to({ y: 825 + 22 }, 50)
            .to({ y: 825 + 24 }, 50)


        egret.Tween.get(this.guideBallon)
            .to({ scaleX: 1.1, scaleY: 1.1 }, 1000)
    }

    guideStep4() {
        this.nextBtn.visible = false;
        this.startBtn.visible = true;
        this.skipBtn.visible = false;

        let mask = GameConst.drawRectMask(150, 25, 450, 275)
        this.step3.visible = false;
        this.step4.visible = true;
        this.step4.addChild(mask)

        let tips = new eui.Label()
        tips.text = `在规定时间内放飞四个感恩\n气球，则游戏成功`
        tips.textAlign = "center"
        tips.verticalAlign = "center"
        tips.lineSpacing = 15;
        tips.horizontalCenter = 0;
        tips.y = 350
        this.step4.addChild(tips)
    }

    // 开始游戏
    restartGame() {
        if (arr.contain(this.gameLayer.$children, this.guideBallon)) {
            this.gameLayer.removeChild(this.guideBallon);
        }

        if (arr.contain(this.gameLayer.$children, this.currBallon)) {
            this.gameLayer.removeChild(this.currBallon);
        }

        this.currBallon = new Ballon(this.ballonsPool[this.sucCount])
        this.currBallon.anchorOffsetX = 161
        this.currBallon.anchorOffsetY = 376;
        this.currBallon.x = 361
        this.currBallon.y = 802
        this.currBallon.scaleX = .5
        this.currBallon.scaleY = .5
        this.gameLayer.addChildAt(this.currBallon, 5)

        this.startCountDown();

    }

    // 确认游戏状态
    async checkGameStatus() {
        if (this.currBallon.scaleX > 0.98 && this.currBallon.scaleX <= 1.02) {
            this.pumpBtn.touchEnabled = false
            this.sucCount++;

            console.log("成功次数：" + this.sucCount + "次");

            // 气球飞上进度条 重置新气球
            await this.currBallonFadeOut()
            await this.smallBallonFadeIn()

            if (this.sucCount >= 4) {
                // 发送分数
                this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_countDown, this)
                this.gameSuc()
                return
            }

            this.leftCount.text = `X${4 - this.sucCount}`
            await this.jumpToPump()

            // this.pumpMark = false;
            this.resetBallon()
        } else {
            // 不发分数
            this.gameFail()
        }
    }

    currBallonFadeOut() {
        return new Promise(r => {
            egret.Tween.get(this.currBallon)
                .to({ y: 780, alpha: 0 }, 500)
                .call(() => {
                    r()
                })

        })
    }

    smallBallonFadeIn() {
        return new Promise(r => {
            let ballon = new eui.Image()
            ballon.source = `ssBallon_${this.sBallonsArr[this.sucCount - 1]}_png`
            ballon.alpha = 0;
            ballon.scaleX = .8;
            ballon.scaleY = .8;
            ballon.x = this[`ssBallon${this.sucCount}`].x
            ballon.y = this[`ssBallon${this.sucCount}`].y + 20
            this.addChild(ballon)


            egret.Tween.get(ballon)
                .to({ y: this[`ssBallon${this.sucCount}`].y - 20, alpha: 1 }, 300)
                .to({ y: this[`ssBallon${this.sucCount}`].y }, 100)
                .call(() => {
                    r()
                })

        })
    }

    jumpToPump() {
        return new Promise((r) => {
            let sBallon = this.sBallonsPool[3 - this.sucCount]
            sBallon.x = 81
            sBallon.y = 863
            this.gameLayer.addChild(sBallon)
            let data = { a: 0 }
            egret.Tween.get(data, {
                onChange: () => {
                    sBallon.x = GameConst.bezier(data.a, 81, 150, 320)
                    sBallon.y = GameConst.bezier(data.a, 863, 650, 670)


                }
            })
                .to({ a: 1 }, 500)
                .call(() => {
                    this.gameLayer.removeChild(sBallon)
                    r()
                })
        })
    }

    resetMark = false
    resetBallon() {
        if (arr.contain(this.gameLayer.$children, this.currBallon)) {
            this.gameLayer.removeChild(this.currBallon);
        }

        this.currBallon = new Ballon(this.ballonsPool[this.sucCount])
        this.currBallon.anchorOffsetX = 161
        this.currBallon.anchorOffsetY = 376;
        this.currBallon.x = 361
        this.currBallon.y = 802
        this.currBallon.scaleX = .5
        this.currBallon.scaleY = .5
        this.gameLayer.addChildAt(this.currBallon, 5)

        this.pumpBtn.touchEnabled = true;
        setTimeout(() => {
            this.resetMark = false;
        }, 500);

    }

    gameSuc() {
        let orderId = DataManager.ins.getData("doJoin").data
        let score = 1
        let submitToken = DataManager.ins.getData("getNgameStartStatus").data.submitToken
        NetPromise.submit(orderId, score, submitToken)
            .then(() => {
                return NetPromise.getOrderStatus()
            })
            .then(() => {
                if (DataManager.ins.getData("getOrderStatus").data.lottery && DataManager.ins.getData("getOrderStatus").data.lottery.type !== "thanks") {
                    PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL)
                } else {
                    let data = { type: noPrizeTypes.NOPRIZE }
                    PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data)
                }
            })
            .catch(e => {
                console.error(e);
                let data = { type: noPrizeTypes.NOPRIZE }
                PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data)
            })
    }

    gameFail() {
        let orderId = DataManager.ins.getData("doJoin").data
        let score = 1
        let submitToken = DataManager.ins.getData("getNgameStartStatus").data.submitToken

        NetConst.ngameSubmit(() => {
            let data = { type: noPrizeTypes.FAIL }
            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data)
        }, orderId, score, '[]', '[]', submitToken)
    }

    endTime: number;
    private async startCountDown() {
        this.ready.visible = true;

        await this.aniNum3()
        await this.aniNum2()
        await this.aniNum1()
        await this.aniReady()
        await this.aniGo()

        this.ready.visible = false;

        let now = GameConst.time.now();
        this.endTime = now + 30000

        this.countDownTxt.text = `30S`
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_countDown, this)
    }

    initEvents() {
        super.initEvents()
        this.pumpBtn.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onDown_pumpBtn, this);

        this.pumpBtn.addEventListener(egret.TouchEvent.TOUCH_END, this.onUp_pumpBtn, this);
        this.pumpBtn.addEventListener(egret.TouchEvent.TOUCH_CANCEL, this.onUp_pumpBtn, this);
        this.pumpBtn.addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onUp_pumpBtn, this);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_smaller, this)
    }


    onTap_startBtn() {
        // 移除引导层
        this.guideLayer.visible = false;
        egret.Tween.removeTweens(this.pumpBtn)
        this.pumpBtn.source = "pumpUpBtn_png"
        this.pumpBtn.y = 825

        this.restartGame()
    }

    onEnterFrame_smaller() {
        if (this.currBallon && this.currBallon.scaleX > .5 && !this.resetMark) {
            this.currBallon.scaleX -= this.pumpSpeed / 20
            this.currBallon.scaleY -= this.pumpSpeed / 20
        }
    }

    onEnterFrame_countDown() {
        let time = Math.floor(GameConst.time.getEndTime(this.endTime).s)
        if (time <= 5) {
            this.countDownTxt.size = 56
            this.countDownTxt.textColor = 0xff0000
        } else {
            this.countDownTxt.size = 42
            this.countDownTxt.textColor = 0xEA7244
        }
        this.countDownTxt.text = `${time}S`
        if (GameConst.time.now() > this.endTime) {
            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_countDown, this)
            this.checkGameStatus()
        }
    }


    onTap_nextBtn() {
        this.guideStep++
        }
    }


    // pumpMark = false;

    pumpSpeed = window["pumpSpeed"] || 0.01
    pumpAddSpeed = window["pumpAddSpeed"] || 0.005
    onDown_pumpBtn() {
        if (this.resetMark) {
            return
        }
        // this.pumpMark = true;
        this.pumpBtn.source = "pumpDownBtn_png"
        this.pumpBtn.y = 825 + 24

        egret.Tween.get(this.pumpBtn, { loop: true })
            .set({ y: 825 + 24 })
            .to({ y: 825 + 22 }, 50)
            .to({ y: 825 + 24 }, 50)

        if (this.currBallon.scaleX < 1.2) {
            this.currBallon.scaleX += this.pumpSpeed
            this.currBallon.scaleY += this.pumpSpeed
            this.pumpSpeed += this.pumpAddSpeed
        } else {

            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_countDown, this)
            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame_smaller, this)

            this.pumpBtn.touchEnabled = false
            let svga = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.getSVGAByName("explode"))
            this.gameLayer.addChild(svga)

            this.currBallon.explodeMark.alpha = 1;
            setTimeout(() => {
                this.gameLayer.removeChild(svga)
                this.gameFail()
            }, 500);

        }
    }


    onUp_pumpBtn() {
        if (this.resetMark) {
            return
        }
        egret.Tween.removeTweens(this.pumpBtn)
        this.pumpBtn.source = "pumpUpBtn_png"
        this.pumpBtn.y = 825

        if (this.currBallon.scaleX > 0.98 && this.currBallon.scaleX <= 1.02) {
            this.resetMark = true
            this.checkGameStatus()
        }
    }



    removeEvents() {
        super.removeEvents()
        this.pumpBtn.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onDown_pumpBtn, this);

        this.pumpBtn.removeEventListener(egret.TouchEvent.TOUCH_END, this.onUp_pumpBtn, this);
        this.pumpBtn.removeEventListener(egret.TouchEvent.TOUCH_CANCEL, this.onUp_pumpBtn, this);
        this.pumpBtn.removeEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onUp_pumpBtn, this);

        this.clearTap(this.skipBtn, this.onTap_startBtn)
        this.clearTap(this.nextBtn, this.onTap_nextBtn)
        this.clearTap(this.startBtn, this.onTap_startBtn)
    }


    aniNum3() {
        return new Promise((r) => {
            this.ready['num3'].alpha = 1;
            egret.Tween.get(this.ready['num3'])
                .to({ scaleX: 1, scaleY: 1 }, 200)
                .wait(600)
                .to({ scaleX: 0, scaleY: 0 }, 200)
                .call(() => {
                    r()
                })
        })
    }


    aniNum2() {
        return new Promise((r) => {
            this.ready['num2'].alpha = 1;
            egret.Tween.get(this.ready['num2'])
                .to({ scaleX: 1, scaleY: 1 }, 200)
                .wait(600)
                .to({ scaleX: 0, scaleY: 0 }, 200)
                .call(() => {
                    r()
                })
        })
    }

    aniNum1() {
        return new Promise((r) => {
            this.ready['num1'].alpha = 1;
            egret.Tween.get(this.ready['num1'])
                .to({ scaleX: 1, scaleY: 1 }, 200)
                .wait(600)
                .to({ scaleX: 0, scaleY: 0 }, 200)
                .call(() => {
                    r()
                })
        })
    }

    aniReady() {
        return new Promise((r) => {
            this.ready['ready'].alpha = 1;
            egret.Tween.get(this.ready['ready'])
                .to({ scaleX: 1, scaleY: 1 }, 200)
                .wait(600)
                .to({ scaleX: 0, scaleY: 0 }, 200)
                .call(() => {
                    r()
                })
        })
    }

    aniGo() {
        return new Promise((r) => {
            this.ready['go'].alpha = 1;
            egret.Tween.get(this.ready['go'])
                .to({ scaleX: 1, scaleY: 1 }, 200)
                .wait(600)
                .to({ scaleX: 0, scaleY: 0 }, 200)
                .call(() => {
                    r()
                })
        })
    }


}

export enum noPrizeTypes {
    THANKS,
    NOPRIZE,
    FAIL
}